/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.gw2api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.regdrasil.gw2api.model.DailyLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "level", "required_access"})
public class Daily {
    public static final String JSON_PROPERTY_ID = "id";
    private Integer id;
    public static final String JSON_PROPERTY_LEVEL = "level";
    private DailyLevel level;
    public static final String JSON_PROPERTY_REQUIRED_ACCESS = "required_access";
    private List<RequiredAccessEnum> requiredAccess;

    public Daily id(Integer id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(Integer id) {
        this.id = id;
    }

    public Daily level(DailyLevel level) {
        this.level = level;
        return this;
    }

    @Nullable
    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DailyLevel getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLevel(DailyLevel level) {
        this.level = level;
    }

    public Daily requiredAccess(List<RequiredAccessEnum> requiredAccess) {
        this.requiredAccess = requiredAccess;
        return this;
    }

    public Daily addRequiredAccessItem(RequiredAccessEnum requiredAccessItem) {
        if (this.requiredAccess == null) {
            this.requiredAccess = new ArrayList<RequiredAccessEnum>();
        }
        this.requiredAccess.add(requiredAccessItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="required_access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RequiredAccessEnum> getRequiredAccess() {
        return this.requiredAccess;
    }

    @JsonProperty(value="required_access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredAccess(List<RequiredAccessEnum> requiredAccess) {
        this.requiredAccess = requiredAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Daily daily = (Daily)o;
        return Objects.equals(this.id, daily.id) && Objects.equals(this.level, daily.level) && Objects.equals(this.requiredAccess, daily.requiredAccess);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.level, this.requiredAccess);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Daily {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    requiredAccess: ").append(this.toIndentedString(this.requiredAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLevel() != null) {
            joiner.add(this.getLevel().toUrlQueryString(prefix + JSON_PROPERTY_LEVEL + suffix));
        }
        if (this.getRequiredAccess() != null) {
            for (int i = 0; i < this.getRequiredAccess().size(); ++i) {
                try {
                    joiner.add(String.format("%srequired_access%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getRequiredAccess().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum RequiredAccessEnum {
        GUILDWARS2("GuildWars2"),
        HEARTOFTHORNS("HeartOfThorns"),
        PATHOFFIRE("PathOfFire");

        private String value;

        private RequiredAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequiredAccessEnum fromValue(String value) {
            for (RequiredAccessEnum b : RequiredAccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

