/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.gw2api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.regdrasil.gw2api.Pair;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ApiClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private HttpClient.Builder builder = HttpClient.newBuilder();
    private ObjectMapper mapper = new ObjectMapper();
    private String scheme;
    private String host;
    private int port;
    private String basePath;
    private Consumer<HttpRequest.Builder> interceptor;
    private Duration readTimeout;

    private static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, UTF_8);
    }

    public static List<Pair> parameterToPairs(String name, Object value) {
        if (name == null || name.isEmpty() || value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Pair(ApiClient.urlEncode(name), ApiClient.urlEncode(value.toString())));
    }

    public static List<Pair> parameterToPairs(String collectionFormat, String name, Collection<?> values) {
        String delimiter;
        String format;
        if (name == null || name.isEmpty() || values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            return values.stream().map(value -> new Pair(ApiClient.urlEncode(name), ApiClient.urlEncode(ApiClient.valueToString(value)))).collect(Collectors.toList());
        }
        switch (format) {
            case "csv": {
                delimiter = ApiClient.urlEncode(",");
                break;
            }
            case "ssv": {
                delimiter = ApiClient.urlEncode(" ");
                break;
            }
            case "tsv": {
                delimiter = ApiClient.urlEncode("\t");
                break;
            }
            case "pipes": {
                delimiter = ApiClient.urlEncode("|");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal collection format: " + collectionFormat);
            }
        }
        StringJoiner joiner = new StringJoiner(delimiter);
        for (Object value2 : values) {
            joiner.add(ApiClient.urlEncode(ApiClient.valueToString(value2)));
        }
        return Collections.singletonList(new Pair(ApiClient.urlEncode(name), joiner.toString()));
    }

    public ApiClient() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.registerModule(new JavaTimeModule());
        URI baseURI = URI.create("https://api.guildwars2.com");
        this.scheme = baseURI.getScheme();
        this.host = baseURI.getHost();
        this.port = baseURI.getPort();
        this.basePath = baseURI.getRawPath();
        this.interceptor = null;
        this.readTimeout = null;
    }

    public ApiClient setHttpClientBuilder(HttpClient.Builder builder) {
        this.builder = builder;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.builder.build();
    }

    public ApiClient setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper.copy();
    }

    public ApiClient setHost(String host) {
        this.host = host;
        return this;
    }

    public ApiClient setPort(int port) {
        this.port = port;
        return this;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getBaseUri() {
        return this.scheme + "://" + this.host + (String)(this.port == -1 ? "" : ":" + this.port) + this.basePath;
    }

    public ApiClient setRequestInterceptor(Consumer<HttpRequest.Builder> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Consumer<HttpRequest.Builder> getRequestInterceptor() {
        return this.interceptor;
    }

    public ApiClient setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }
}

