/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.gw2api.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.regdrasil.gw2api.ApiClient;
import com.regdrasil.gw2api.ApiException;
import com.regdrasil.gw2api.Pair;
import com.regdrasil.gw2api.model.Account;
import com.regdrasil.gw2api.model.Achievement;
import com.regdrasil.gw2api.model.Character;
import com.regdrasil.gw2api.model.InlineResponse200;
import com.regdrasil.gw2api.model.InlineResponse2001;
import com.regdrasil.gw2api.model.Profession;
import com.regdrasil.gw2api.model.PvpRank;
import com.regdrasil.gw2api.model.Skill;
import com.regdrasil.gw2api.model.SkillsContainer;
import com.regdrasil.gw2api.model.Specialization;
import com.regdrasil.gw2api.model.Trait;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class DefaultApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;

    public DefaultApi() {
        this(new ApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
    }

    public List<Achievement> getAchievements(List<Integer> ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getAchievements");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/achievements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getAchievements call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Achievement>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public SkillsContainer getCharacterSkills(String id, String accessToken) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getCharacterSkills");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/characters/{id}/skills".replace("{id}", ApiClient.urlEncode(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getCharacterSkills call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (SkillsContainer)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<SkillsContainer>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Profession getProfession(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProfession");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/professions/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getProfession call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Profession)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Profession>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Profession> getProfessions(String ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getProfessions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/professions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getProfessions call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Profession>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public PvpRank getPvpRank(Integer id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getPvpRank");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/pvp/ranks/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getPvpRank call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (PvpRank)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PvpRank>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<PvpRank> getPvpRanks(String ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getPvpRanks");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/pvp/ranks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getPvpRanks call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<PvpRank>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Account v2GetAccount(String accessToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2GetAccount call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Account)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Account>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public InlineResponse2001 v2GetAchievementsDaily() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/achievements/daily";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2GetAchievementsDaily call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (InlineResponse2001)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<InlineResponse2001>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<InlineResponse200> v2GetFiles(List<String> ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling v2GetFiles");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/files";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2GetFiles call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<InlineResponse200>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Character v2getCharacter20191219T000000000Z(String v, String id, String accessToken) throws ApiException {
        if (v == null) {
            throw new ApiException(400, "Missing the required parameter 'v' when calling v2getCharacter20191219T000000000Z");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling v2getCharacter20191219T000000000Z");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/characters/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2getCharacter20191219T000000000Z call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Character)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Character>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Skill> v2getSkills(List<Integer> ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling v2getSkills");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/skills";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2getSkills call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Skill>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Specialization> v2getSpecializations(List<Integer> ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling v2getSpecializations");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/specializations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2getSpecializations call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Specialization>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Trait> v2getTraits(List<Integer> ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling v2getTraits");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/traits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2getTraits call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Trait>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }
}

