/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.gw2api.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.regdrasil.gw2api.ApiClient;
import com.regdrasil.gw2api.ApiException;
import com.regdrasil.gw2api.Pair;
import com.regdrasil.gw2api.model.Account;
import com.regdrasil.gw2api.model.Daily;
import com.regdrasil.gw2api.model.Profession;
import com.regdrasil.gw2api.model.PvpRank;
import com.regdrasil.gw2api.model.Skill;
import com.regdrasil.gw2api.model.SkillsContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class DefaultApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;

    public DefaultApi() {
        this(new ApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
    }

    public void getAchievements(List<Integer> ids, String accessToken) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getAchievements");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/achievements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getAchievements call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public SkillsContainer getCharacterSkills(String id, String accessToken) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getCharacterSkills");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/characters/{id}/skills".replace("{id}", ApiClient.urlEncode(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getCharacterSkills call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (SkillsContainer)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<SkillsContainer>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Profession getProfession(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProfession");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/professions/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getProfession call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Profession)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Profession>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Profession> getProfessions(String ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getProfessions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/professions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getProfessions call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Profession>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public PvpRank getPvpRank(Integer id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getPvpRank");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/pvp/ranks/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getPvpRank call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (PvpRank)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PvpRank>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<PvpRank> getPvpRanks(String ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getPvpRanks");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/pvp/ranks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getPvpRanks call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<PvpRank>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public List<Skill> getSkills(String ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling getSkills");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/skills";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "getSkills call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Skill>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Account v2GetAccount(String accessToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2GetAccount call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Account)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Account>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }

    public Daily v2GetAchievementsDaily(String accessToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v2/achievements/daily";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(ApiClient.parameterToPairs("access_token", accessToken));
        if (!localVarQueryParams.isEmpty()) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> localVarResponse;
            localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            if (this.memberVarReadTimeout != null) {
                localVarRequestBuilder.timeout(this.memberVarReadTimeout);
            }
            if (this.memberVarInterceptor != null) {
                this.memberVarInterceptor.accept(localVarRequestBuilder);
            }
            if ((localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() / 100 != 2) {
                throw new ApiException(localVarResponse.statusCode(), "v2GetAchievementsDaily call received non-success response", localVarResponse.headers(), localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
            }
            return (Daily)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Daily>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new ApiException(e);
        }
    }
}

