/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.discordbot;

import com.regdrasil.discordbot.cmd.Command;
import com.regdrasil.discordbot.cmd.CommandListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.javacord.api.DiscordApi;
import org.javacord.api.DiscordApiBuilder;
import org.javacord.api.entity.permission.Permissions;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Main {
    private static int DISCORD_PERMISSIONS = 3669056;
    private static DiscordApi api;
    public static final Map<String, Map<String, String[]>> HELPS;

    public static void main(String[] args2) throws ParseException {
        Options options = new Options();
        options.addOption("dk", "discord-key", true, "Path to the file containing the discord key (default to discordkey)");
        options.addOption("dp", "discord-permissions", true, String.format("Discord permissions (default to %d)", DISCORD_PERMISSIONS));
        DefaultParser commandLineParser = new DefaultParser();
        CommandLine cmd = commandLineParser.parse(options, args2);
        if (cmd.hasOption("dp")) {
            try {
                DISCORD_PERMISSIONS = Integer.parseInt(cmd.getOptionValue("dp"));
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Error reading permissions " + cmd.getOptionValue("dp"), ex);
                System.exit(1);
            }
        }
        String discordkey = null;
        try {
            discordkey = new String(Files.readAllBytes(Paths.get(cmd.getOptionValue("dk", "discordkey"), new String[0])), StandardCharsets.UTF_8).trim();
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Error loading discord key", ex);
            System.exit(1);
        }
        Logger.getLogger(Main.class.getName()).info("Login ...");
        api = new DiscordApiBuilder().setToken(discordkey).login().join();
        Logger.getLogger(Main.class.getName()).info("Loading commands ...");
        int count = 0;
        for (Class<CommandListener> t : new Reflections("com.regdrasil.discordbot", new Scanner[0]).getSubTypesOf(CommandListener.class)) {
            try {
                Command annotation = t.getAnnotation(Command.class);
                if (annotation == null) continue;
                api.addMessageCreateListener(t.newInstance());
                if (annotation.help().length == 0) continue;
                if (!HELPS.containsKey(annotation.helpSection())) {
                    HELPS.put(annotation.helpSection(), new TreeMap());
                }
                HELPS.get(annotation.helpSection()).put(t.getSimpleName(), annotation.help());
                ++count;
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Logger.getLogger(Main.class.getName()).log(Level.INFO, "{0} command(s) loaded", count);
        Logger.getLogger(Main.class.getName()).log(Level.INFO, "You can invite the bot by using the following url: {0}", api.createBotInvite(Permissions.fromBitmask(DISCORD_PERMISSIONS)));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Logger.getLogger(Main.class.getName()).info("Disconecting ...");
                api.disconnect();
                Logger.getLogger(Main.class.getName()).info("Disconected");
            }
        });
    }

    static {
        HELPS = new TreeMap<String, Map<String, String[]>>();
    }
}

