/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.rest;

import java.util.Optional;
import okhttp3.HttpUrl;

public enum RestEndpoint {
    GATEWAY("/gateway"),
    GATEWAY_BOT("/gateway/bot"),
    MESSAGE("/channels/%s/messages", 0),
    MESSAGE_DELETE("/channels/%s/messages", 0),
    MESSAGES_BULK_DELETE("/channels/%s/messages/bulk-delete", 0),
    CHANNEL_TYPING("/channels/%s/typing", 0),
    CHANNEL_INVITE("/channels/%s/invites", 0),
    USER("/users/%s"),
    USER_CHANNEL("/users/@me/channels"),
    CHANNEL("/channels/%s", 0),
    ROLE("/guilds/%s/roles", 0),
    SERVER("/guilds", 0),
    SERVER_PRUNE("/guilds/%s/prune", 0),
    SERVER_SELF("/users/@me/guilds/%s", 0),
    SERVER_CHANNEL("/guilds/%s/channels", 0),
    REACTION("/channels/%s/messages/%s/reactions", 0, 250),
    PINS("/channels/%s/pins", 0),
    SERVER_MEMBER("/guilds/%s/members/%s", 0),
    SERVER_MEMBER_ROLE("/guilds/%s/members/%s/roles/%s", 0),
    OWN_NICKNAME("/guilds/%s/members/@me/nick", 0),
    SELF_INFO("/oauth2/applications/@me"),
    CHANNEL_WEBHOOK("/channels/%s/webhooks", 0),
    SERVER_WEBHOOK("/guilds/%s/webhooks", 0),
    SERVER_INVITE("/guilds/%s/invites", 0),
    WEBHOOK("/webhooks/%s", 0),
    INVITE("/invites/%s"),
    BAN("/guilds/%s/bans", 0),
    CURRENT_USER("/users/@me"),
    AUDIT_LOG("/guilds/%s/audit-logs", 0),
    CUSTOM_EMOJI("/guilds/%s/emojis", 0);

    private final String endpointUrl;
    private final int majorParameterPosition;
    private boolean global;
    private final int hardcodedRatelimit;

    private RestEndpoint(String endpointUrl) {
        this(endpointUrl, -1, false, -1);
    }

    private RestEndpoint(String endpointUrl, boolean global) {
        this(endpointUrl, -1, global, -1);
    }

    private RestEndpoint(String endpointUrl, int majorParameterPosition) {
        this(endpointUrl, majorParameterPosition, false, -1);
    }

    private RestEndpoint(String endpointUrl, int majorParameterPosition, int hardcodedRatelimit) {
        this(endpointUrl, majorParameterPosition, false, hardcodedRatelimit);
    }

    private RestEndpoint(String endpointUrl, int majorParameterPosition, boolean global) {
        this(endpointUrl, majorParameterPosition, false, -1);
    }

    private RestEndpoint(String endpointUrl, int majorParameterPosition, boolean global, int hardcodedRatelimit) {
        this.endpointUrl = endpointUrl;
        this.majorParameterPosition = majorParameterPosition;
        this.global = global;
        this.hardcodedRatelimit = hardcodedRatelimit;
    }

    public Optional<Integer> getMajorParameterPosition() {
        if (this.majorParameterPosition >= 0) {
            return Optional.of(this.majorParameterPosition);
        }
        return Optional.empty();
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public Optional<Integer> getHardcodedRatelimit() {
        if (this.hardcodedRatelimit >= 0) {
            return Optional.of(this.hardcodedRatelimit);
        }
        return Optional.empty();
    }

    public String getFullUrl(String ... parameters) {
        StringBuilder url = new StringBuilder("https://discordapp.com/api/v6" + this.getEndpointUrl());
        url = new StringBuilder(String.format(url.toString(), parameters));
        int parameterAmount = this.getEndpointUrl().split("%s").length - (this.getEndpointUrl().endsWith("%s") ? 0 : 1);
        if (parameters.length > parameterAmount) {
            for (int i = parameterAmount; i < parameters.length; ++i) {
                url.append("/").append(parameters[i]);
            }
        }
        return url.toString();
    }

    public HttpUrl getOkHttpUrl(String ... parameters) {
        return HttpUrl.parse(this.getFullUrl(parameters));
    }
}

