/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.user;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordClient;
import org.javacord.api.entity.activity.Activity;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.api.event.user.UserChangeActivityEvent;
import org.javacord.api.event.user.UserChangeAvatarEvent;
import org.javacord.api.event.user.UserChangeDiscriminatorEvent;
import org.javacord.api.event.user.UserChangeNameEvent;
import org.javacord.api.event.user.UserChangeStatusEvent;
import org.javacord.core.entity.activity.ActivityImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.event.user.UserChangeActivityEventImpl;
import org.javacord.core.event.user.UserChangeAvatarEventImpl;
import org.javacord.core.event.user.UserChangeDiscriminatorEventImpl;
import org.javacord.core.event.user.UserChangeNameEventImpl;
import org.javacord.core.event.user.UserChangeStatusEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class PresenceUpdateHandler
extends PacketHandler {
    public PresenceUpdateHandler(DiscordApi api) {
        super(api, true, "PRESENCE_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        long userId = packet.get("user").get("id").asLong();
        this.api.getCachedUserById(userId).map(UserImpl.class::cast).ifPresent(user -> {
            String oldAvatarHash;
            String newAvatarHash;
            UserStatus oldStatus;
            if (packet.has("game")) {
                ActivityImpl newActivity = null;
                if (!packet.get("game").isNull()) {
                    newActivity = new ActivityImpl(packet.get("game"));
                }
                Activity oldActivity = user.getActivity().orElse(null);
                user.setActivity(newActivity);
                if (!Objects.deepEquals(newActivity, oldActivity)) {
                    this.dispatchUserActivityChangeEvent((User)user, newActivity, oldActivity);
                }
            }
            UserStatus newStatus = oldStatus = user.getStatus();
            if (packet.has("status")) {
                newStatus = UserStatus.fromString(packet.get("status").asText(null));
                user.setStatus(newStatus);
            }
            HashMap<DiscordClient, UserStatus> newClientStatus = new HashMap<DiscordClient, UserStatus>();
            HashMap<DiscordClient, UserStatus> oldClientStatus = new HashMap<DiscordClient, UserStatus>();
            for (DiscordClient client : DiscordClient.values()) {
                oldClientStatus.put(client, user.getStatusOnClient(client));
                if (packet.has("client_status")) {
                    JsonNode clientStatus = packet.get("client_status");
                    if (clientStatus.hasNonNull(client.getName())) {
                        UserStatus status = UserStatus.fromString(clientStatus.get(client.getName()).asText());
                        user.setClientStatus(client, status);
                    } else {
                        user.setClientStatus(client, UserStatus.OFFLINE);
                    }
                }
                newClientStatus.put(client, user.getStatusOnClient(client));
            }
            this.dispatchUserStatusChangeEventIfChangeDetected((User)user, newStatus, oldStatus, (Map<DiscordClient, UserStatus>)newClientStatus, (Map<DiscordClient, UserStatus>)oldClientStatus);
            if (packet.get("user").has("username")) {
                String newName = packet.get("user").get("username").asText();
                String oldName = user.getName();
                if (!oldName.equals(newName)) {
                    user.setName(newName);
                    this.dispatchUserChangeNameEvent((User)user, newName, oldName);
                }
            }
            if (packet.get("user").has("discriminator")) {
                String newDiscriminator = packet.get("user").get("discriminator").asText();
                String oldDiscriminator = user.getDiscriminator();
                if (!oldDiscriminator.equals(newDiscriminator)) {
                    user.setDiscriminator(newDiscriminator);
                    this.dispatchUserChangeDiscriminatorEvent((User)user, newDiscriminator, oldDiscriminator);
                }
            }
            if (packet.get("user").has("avatar") && !Objects.deepEquals(newAvatarHash = packet.get("user").get("avatar").asText(null), oldAvatarHash = user.getAvatarHash())) {
                user.setAvatarHash(newAvatarHash);
                this.dispatchUserChangeAvatarEvent((User)user, newAvatarHash, oldAvatarHash);
            }
        });
    }

    private void dispatchUserActivityChangeEvent(User user, Activity newActivity, Activity oldActivity) {
        UserChangeActivityEventImpl event = new UserChangeActivityEventImpl(user, newActivity, oldActivity);
        this.api.getEventDispatcher().dispatchUserChangeActivityEvent((DispatchQueueSelector)this.api, user.getMutualServers(), Collections.singleton(user), (UserChangeActivityEvent)event);
    }

    private void dispatchUserStatusChangeEventIfChangeDetected(User user, UserStatus newStatus, UserStatus oldStatus, Map<DiscordClient, UserStatus> newClientStatus, Map<DiscordClient, UserStatus> oldClientStatus) {
        boolean shouldDispatch = false;
        if (newClientStatus != oldClientStatus) {
            shouldDispatch = true;
        }
        for (DiscordClient client : DiscordClient.values()) {
            if (newClientStatus.get((Object)client) == oldClientStatus.get((Object)client)) continue;
            shouldDispatch = true;
        }
        if (!shouldDispatch) {
            return;
        }
        UserChangeStatusEventImpl event = new UserChangeStatusEventImpl(user, newStatus, oldStatus, newClientStatus, oldClientStatus);
        this.api.getEventDispatcher().dispatchUserChangeStatusEvent((DispatchQueueSelector)this.api, user.getMutualServers(), Collections.singleton(user), (UserChangeStatusEvent)event);
    }

    private void dispatchUserChangeNameEvent(User user, String newName, String oldName) {
        UserChangeNameEventImpl event = new UserChangeNameEventImpl(user, newName, oldName);
        this.api.getEventDispatcher().dispatchUserChangeNameEvent((DispatchQueueSelector)this.api, user.getMutualServers(), Collections.singleton(user), (UserChangeNameEvent)event);
    }

    private void dispatchUserChangeDiscriminatorEvent(User user, String newDiscriminator, String oldDiscriminator) {
        UserChangeDiscriminatorEventImpl event = new UserChangeDiscriminatorEventImpl(user, newDiscriminator, oldDiscriminator);
        this.api.getEventDispatcher().dispatchUserChangeDiscriminatorEvent((DispatchQueueSelector)this.api, user.getMutualServers(), Collections.singleton(user), (UserChangeDiscriminatorEvent)event);
    }

    private void dispatchUserChangeAvatarEvent(User user, String newAvatarHash, String oldAvatarHash) {
        UserChangeAvatarEventImpl event = new UserChangeAvatarEventImpl(user, newAvatarHash, oldAvatarHash);
        this.api.getEventDispatcher().dispatchUserChangeAvatarEvent((DispatchQueueSelector)this.api, user.getMutualServers(), Collections.singleton(user), (UserChangeAvatarEvent)event);
    }
}

