/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.message.reaction;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.emoji.Emoji;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.message.reaction.ReactionRemoveEvent;
import org.javacord.core.entity.emoji.UnicodeEmojiImpl;
import org.javacord.core.entity.message.MessageImpl;
import org.javacord.core.event.message.reaction.ReactionRemoveEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class MessageReactionRemoveHandler
extends PacketHandler {
    public MessageReactionRemoveHandler(DiscordApi api) {
        super(api, true, "MESSAGE_REACTION_REMOVE");
    }

    @Override
    public void handle(JsonNode packet) {
        this.api.getTextChannelById(packet.get("channel_id").asText()).ifPresent(channel -> {
            long messageId = packet.get("message_id").asLong();
            User user = this.api.getCachedUserById(packet.get("user_id").asText()).orElseThrow(AssertionError::new);
            Optional<Message> message = this.api.getCachedMessageById(messageId);
            JsonNode emojiJson = packet.get("emoji");
            Emoji emoji = !emojiJson.has("id") || emojiJson.get("id").isNull() ? UnicodeEmojiImpl.fromString(emojiJson.get("name").asText()) : this.api.getKnownCustomEmojiOrCreateCustomEmoji(emojiJson);
            message.ifPresent(msg -> ((MessageImpl)msg).removeReaction(emoji, user.isYourself()));
            ReactionRemoveEventImpl event = new ReactionRemoveEventImpl(this.api, messageId, (TextChannel)channel, emoji, user);
            Optional<Server> optionalServer = channel.asServerChannel().map(ServerChannel::getServer);
            this.api.getEventDispatcher().dispatchReactionRemoveEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), messageId, (Server)optionalServer.orElse(null), (TextChannel)channel, user, (ReactionRemoveEvent)event);
        });
    }
}

