/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.guild;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.channel.server.voice.ServerVoiceChannelMemberJoinEvent;
import org.javacord.api.event.channel.server.voice.ServerVoiceChannelMemberLeaveEvent;
import org.javacord.api.event.user.UserChangeDeafenedEvent;
import org.javacord.api.event.user.UserChangeMutedEvent;
import org.javacord.api.event.user.UserChangeSelfDeafenedEvent;
import org.javacord.api.event.user.UserChangeSelfMutedEvent;
import org.javacord.core.entity.channel.GroupChannelImpl;
import org.javacord.core.entity.channel.PrivateChannelImpl;
import org.javacord.core.entity.channel.ServerVoiceChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.event.channel.server.voice.ServerVoiceChannelMemberJoinEventImpl;
import org.javacord.core.event.channel.server.voice.ServerVoiceChannelMemberLeaveEventImpl;
import org.javacord.core.event.user.UserChangeDeafenedEventImpl;
import org.javacord.core.event.user.UserChangeMutedEventImpl;
import org.javacord.core.event.user.UserChangeSelfDeafenedEventImpl;
import org.javacord.core.event.user.UserChangeSelfMutedEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class VoiceStateUpdateHandler
extends PacketHandler {
    public VoiceStateUpdateHandler(DiscordApi api) {
        super(api, true, "VOICE_STATE_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        if (!packet.hasNonNull("user_id")) {
            return;
        }
        long userId = packet.get("user_id").asLong();
        if (packet.hasNonNull("guild_id")) {
            this.handleServerVoiceChannel(packet, userId);
        } else if (packet.hasNonNull("channel_id")) {
            long channelId = packet.get("channel_id").asLong();
            this.api.getVoiceChannelById(channelId).ifPresent(voiceChannel -> {
                if (voiceChannel instanceof PrivateChannel) {
                    this.handlePrivateChannel(userId, (PrivateChannelImpl)voiceChannel);
                } else if (voiceChannel instanceof GroupChannel) {
                    this.handleGroupChannel(userId, (GroupChannelImpl)voiceChannel);
                }
            });
        }
    }

    private void handleServerVoiceChannel(JsonNode packet, long userId) {
        this.api.getPossiblyUnreadyServerById(packet.get("guild_id").asLong()).map(ServerImpl.class::cast).ifPresent(server -> {
            boolean oldDeafened;
            boolean newDeafened;
            boolean oldMuted;
            boolean newMuted;
            boolean oldSelfDeafened;
            boolean newSelfDeafened;
            boolean oldSelfMuted;
            boolean newSelfMuted;
            Optional<ServerVoiceChannelImpl> oldChannel = server.getConnectedVoiceChannel(userId).map(ServerVoiceChannelImpl.class::cast);
            Optional<Object> newChannel = packet.hasNonNull("channel_id") ? server.getVoiceChannelById(packet.get("channel_id").asLong()).map(ServerVoiceChannelImpl.class::cast) : Optional.empty();
            if (!newChannel.equals(oldChannel)) {
                oldChannel.ifPresent(channel -> {
                    channel.removeConnectedUser(userId);
                    this.dispatchServerVoiceChannelMemberLeaveEvent(userId, newChannel.orElse(null), (ServerVoiceChannel)channel, (Server)server);
                });
                newChannel.ifPresent(channel -> {
                    channel.addConnectedUser(userId);
                    this.dispatchServerVoiceChannelMemberJoinEvent(userId, (ServerVoiceChannel)channel, oldChannel.orElse(null), (Server)server);
                });
            }
            if ((newSelfMuted = packet.get("self_mute").asBoolean()) != (oldSelfMuted = server.isSelfMuted(userId))) {
                server.setSelfMuted(userId, newSelfMuted);
                this.dispatchUserChangeSelfMutedEvent(userId, (Server)server, newSelfMuted, oldSelfMuted);
            }
            if ((newSelfDeafened = packet.get("self_deaf").asBoolean()) != (oldSelfDeafened = server.isSelfDeafened(userId))) {
                server.setSelfDeafened(userId, newSelfDeafened);
                this.dispatchUserChangeSelfDeafenedEvent(userId, (Server)server, newSelfDeafened, oldSelfDeafened);
            }
            if ((newMuted = packet.get("mute").asBoolean()) != (oldMuted = server.isMuted(userId))) {
                server.setMuted(userId, newMuted);
                this.dispatchUserChangeMutedEvent(userId, (Server)server, newMuted, oldMuted);
            }
            if ((newDeafened = packet.get("deaf").asBoolean()) != (oldDeafened = server.isDeafened(userId))) {
                server.setDeafened(userId, newDeafened);
                this.dispatchUserChangeDeafenedEvent(userId, (Server)server, newDeafened, oldDeafened);
            }
        });
    }

    private void handlePrivateChannel(long userId, PrivateChannelImpl channel) {
    }

    private void handleGroupChannel(long userId, GroupChannelImpl channel) {
    }

    private void dispatchServerVoiceChannelMemberJoinEvent(Long userId, ServerVoiceChannel newChannel, ServerVoiceChannel oldChannel, Server server) {
        ServerVoiceChannelMemberJoinEventImpl event = new ServerVoiceChannelMemberJoinEventImpl(userId, newChannel, oldChannel);
        this.api.getEventDispatcher().dispatchServerVoiceChannelMemberJoinEvent((DispatchQueueSelector)((Object)server), server, newChannel, userId, (ServerVoiceChannelMemberJoinEvent)event);
    }

    private void dispatchServerVoiceChannelMemberLeaveEvent(Long userId, ServerVoiceChannel newChannel, ServerVoiceChannel oldChannel, Server server) {
        ServerVoiceChannelMemberLeaveEventImpl event = new ServerVoiceChannelMemberLeaveEventImpl(userId, newChannel, oldChannel);
        this.api.getEventDispatcher().dispatchServerVoiceChannelMemberLeaveEvent((DispatchQueueSelector)((Object)server), server, oldChannel, userId, (ServerVoiceChannelMemberLeaveEvent)event);
    }

    private void dispatchUserChangeSelfMutedEvent(Long userId, Server server, boolean newSelfMuted, boolean oldSelfMuted) {
        UserChangeSelfMutedEventImpl event = new UserChangeSelfMutedEventImpl(userId, server, newSelfMuted, oldSelfMuted);
        this.api.getEventDispatcher().dispatchUserChangeSelfMutedEvent((DispatchQueueSelector)((Object)server), server, userId, (UserChangeSelfMutedEvent)event);
    }

    private void dispatchUserChangeSelfDeafenedEvent(Long userId, Server server, boolean newSelfDeafened, boolean oldSelfDeafened) {
        UserChangeSelfDeafenedEventImpl event = new UserChangeSelfDeafenedEventImpl(userId, server, newSelfDeafened, oldSelfDeafened);
        this.api.getEventDispatcher().dispatchUserChangeSelfDeafenedEvent((DispatchQueueSelector)((Object)server), server, userId, (UserChangeSelfDeafenedEvent)event);
    }

    private void dispatchUserChangeMutedEvent(Long userId, Server server, boolean newMuted, boolean oldMuted) {
        UserChangeMutedEventImpl event = new UserChangeMutedEventImpl(userId, server, newMuted, oldMuted);
        this.api.getEventDispatcher().dispatchUserChangeMutedEvent((DispatchQueueSelector)((Object)server), server, userId, (UserChangeMutedEvent)event);
    }

    private void dispatchUserChangeDeafenedEvent(Long userId, Server server, boolean newDeafened, boolean oldDeafened) {
        UserChangeDeafenedEventImpl event = new UserChangeDeafenedEventImpl(userId, server, newDeafened, oldDeafened);
        this.api.getEventDispatcher().dispatchUserChangeDeafenedEvent((DispatchQueueSelector)((Object)server), server, userId, (UserChangeDeafenedEvent)event);
    }
}

