/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.event.channel.group.GroupChannelDeleteEvent;
import org.javacord.api.event.channel.server.ServerChannelDeleteEvent;
import org.javacord.api.event.channel.user.PrivateChannelDeleteEvent;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.event.channel.group.GroupChannelDeleteEventImpl;
import org.javacord.core.event.channel.server.ServerChannelDeleteEventImpl;
import org.javacord.core.event.channel.user.PrivateChannelDeleteEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.logging.LoggerUtil;

public class ChannelDeleteHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelDeleteHandler.class);

    public ChannelDeleteHandler(DiscordApi api) {
        super(api, true, "CHANNEL_DELETE");
    }

    @Override
    public void handle(JsonNode packet) {
        ChannelType type = ChannelType.fromId(packet.get("type").asInt());
        switch (type) {
            case SERVER_TEXT_CHANNEL: {
                this.handleServerTextChannel(packet);
                break;
            }
            case PRIVATE_CHANNEL: {
                this.handlePrivateChannel(packet);
                break;
            }
            case SERVER_VOICE_CHANNEL: {
                this.handleServerVoiceChannel(packet);
                break;
            }
            case GROUP_CHANNEL: {
                this.handleGroupChannel(packet);
                break;
            }
            case CHANNEL_CATEGORY: {
                this.handleCategory(packet);
                break;
            }
            case SERVER_NEWS_CHANNEL: {
                this.handleServerTextChannel(packet);
                break;
            }
            case SERVER_STORE_CHANNEL: {
                logger.debug("Received CHANNEL_DELETE packet for a store channel. These are not supported in this Javacord version and get ignored!");
                break;
            }
            default: {
                logger.warn("Unknown or unexpected channel type. Your Javacord version might be out of date!");
            }
        }
        this.api.removeChannelFromCache(packet.get("id").asLong());
    }

    private void handleCategory(JsonNode channelJson) {
        long serverId = channelJson.get("guild_id").asLong();
        long channelId = channelJson.get("id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> server.getChannelCategoryById(channelId).ifPresent(channel -> {
            this.dispatchServerChannelDeleteEvent((ServerChannel)channel);
            ((ServerImpl)server).removeChannelFromCache(channel.getId());
        }));
        this.api.removeObjectListeners(ChannelCategory.class, channelId);
        this.api.removeObjectListeners(ServerChannel.class, channelId);
        this.api.removeObjectListeners(Channel.class, channelId);
    }

    private void handleServerTextChannel(JsonNode channelJson) {
        long serverId = channelJson.get("guild_id").asLong();
        long channelId = channelJson.get("id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> server.getTextChannelById(channelId).ifPresent(channel -> {
            this.dispatchServerChannelDeleteEvent((ServerChannel)channel);
            ((ServerImpl)server).removeChannelFromCache(channel.getId());
            this.api.forEachCachedMessageWhere(msg -> msg.getChannel().getId() == channelId, msg -> this.api.removeMessageFromCache(msg.getId()));
        }));
        this.api.removeObjectListeners(ServerTextChannel.class, channelId);
        this.api.removeObjectListeners(ServerChannel.class, channelId);
        this.api.removeObjectListeners(TextChannel.class, channelId);
        this.api.removeObjectListeners(Channel.class, channelId);
    }

    private void handleServerVoiceChannel(JsonNode channelJson) {
        long serverId = channelJson.get("guild_id").asLong();
        long channelId = channelJson.get("id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> server.getVoiceChannelById(channelId).ifPresent(channel -> {
            this.dispatchServerChannelDeleteEvent((ServerChannel)channel);
            ((ServerImpl)server).removeChannelFromCache(channel.getId());
        }));
        this.api.removeObjectListeners(ServerVoiceChannel.class, channelId);
        this.api.removeObjectListeners(ServerChannel.class, channelId);
        this.api.removeObjectListeners(VoiceChannel.class, channelId);
        this.api.removeObjectListeners(Channel.class, channelId);
    }

    private void handlePrivateChannel(JsonNode channel) {
        UserImpl recipient = (UserImpl)this.api.getOrCreateUser(channel.get("recipients").get(0));
        recipient.getPrivateChannel().ifPresent(privateChannel -> {
            PrivateChannelDeleteEventImpl event = new PrivateChannelDeleteEventImpl((PrivateChannel)privateChannel);
            this.api.getEventDispatcher().dispatchPrivateChannelDeleteEvent((DispatchQueueSelector)this.api, (PrivateChannel)privateChannel, recipient, (PrivateChannelDeleteEvent)event);
            long channelId = privateChannel.getId();
            this.api.removeObjectListeners(PrivateChannel.class, channelId);
            this.api.removeObjectListeners(VoiceChannel.class, channelId);
            this.api.removeObjectListeners(TextChannel.class, channelId);
            this.api.removeObjectListeners(Channel.class, channelId);
            this.api.forEachCachedMessageWhere(msg -> msg.getChannel().getId() == privateChannel.getId(), msg -> this.api.removeMessageFromCache(msg.getId()));
            recipient.setChannel(null);
        });
    }

    private void handleGroupChannel(JsonNode channel) {
        long channelId = channel.get("id").asLong();
        this.api.getGroupChannelById(channelId).ifPresent(groupChannel -> {
            GroupChannelDeleteEventImpl event = new GroupChannelDeleteEventImpl((GroupChannel)groupChannel);
            this.api.getEventDispatcher().dispatchGroupChannelDeleteEvent((DispatchQueueSelector)this.api, Collections.singleton(groupChannel), groupChannel.getMembers(), (GroupChannelDeleteEvent)event);
            this.api.removeObjectListeners(GroupChannel.class, channelId);
            this.api.removeObjectListeners(VoiceChannel.class, channelId);
            this.api.removeObjectListeners(TextChannel.class, channelId);
            this.api.removeObjectListeners(Channel.class, channelId);
            this.api.forEachCachedMessageWhere(msg -> msg.getChannel().getId() == groupChannel.getId(), msg -> this.api.removeMessageFromCache(msg.getId()));
        });
    }

    private void dispatchServerChannelDeleteEvent(ServerChannel channel) {
        ServerChannelDeleteEventImpl event = new ServerChannelDeleteEventImpl(channel);
        this.api.getEventDispatcher().dispatchServerChannelDeleteEvent((DispatchQueueSelector)((Object)channel.getServer()), channel.getServer(), channel, (ServerChannelDeleteEvent)event);
    }
}

