/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.channel;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.channel.group.GroupChannelCreateEvent;
import org.javacord.api.event.channel.server.ServerChannelCreateEvent;
import org.javacord.api.event.channel.user.PrivateChannelCreateEvent;
import org.javacord.core.entity.channel.GroupChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.event.channel.group.GroupChannelCreateEventImpl;
import org.javacord.core.event.channel.server.ServerChannelCreateEventImpl;
import org.javacord.core.event.channel.user.PrivateChannelCreateEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.logging.LoggerUtil;

public class ChannelCreateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelCreateHandler.class);

    public ChannelCreateHandler(DiscordApi api) {
        super(api, true, "CHANNEL_CREATE");
    }

    @Override
    public void handle(JsonNode packet) {
        ChannelType type = ChannelType.fromId(packet.get("type").asInt());
        switch (type) {
            case SERVER_TEXT_CHANNEL: {
                this.handleServerTextChannel(packet);
                break;
            }
            case PRIVATE_CHANNEL: {
                this.handlePrivateChannel(packet);
                break;
            }
            case SERVER_VOICE_CHANNEL: {
                this.handleServerVoiceChannel(packet);
                break;
            }
            case GROUP_CHANNEL: {
                this.handleGroupChannel(packet);
                break;
            }
            case CHANNEL_CATEGORY: {
                this.handleChannelCategory(packet);
                break;
            }
            case SERVER_NEWS_CHANNEL: {
                logger.debug("Received CHANNEL_CREATE packet for a news channel. In this Javacord version it is treated as a normal text channel!");
                this.handleServerTextChannel(packet);
                break;
            }
            case SERVER_STORE_CHANNEL: {
                logger.debug("Received CHANNEL_CREATE packet for a store channel. These are not supported in this Javacord version and get ignored!");
                break;
            }
            default: {
                logger.warn("Unknown or unexpected channel type. Your Javacord version might be out of date!");
            }
        }
    }

    private void handleChannelCategory(JsonNode channel) {
        long serverId = channel.get("guild_id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> {
            ChannelCategory channelCategory = ((ServerImpl)server).getOrCreateChannelCategory(channel);
            ServerChannelCreateEventImpl event = new ServerChannelCreateEventImpl(channelCategory);
            this.api.getEventDispatcher().dispatchServerChannelCreateEvent((DispatchQueueSelector)((Object)server), (Server)server, (ServerChannelCreateEvent)event);
        });
    }

    private void handleServerTextChannel(JsonNode channel) {
        long serverId = channel.get("guild_id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> {
            ServerTextChannel textChannel = ((ServerImpl)server).getOrCreateServerTextChannel(channel);
            ServerChannelCreateEventImpl event = new ServerChannelCreateEventImpl(textChannel);
            this.api.getEventDispatcher().dispatchServerChannelCreateEvent((DispatchQueueSelector)((Object)server), (Server)server, (ServerChannelCreateEvent)event);
        });
    }

    private void handleServerVoiceChannel(JsonNode channel) {
        long serverId = channel.get("guild_id").asLong();
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> {
            ServerVoiceChannel voiceChannel = ((ServerImpl)server).getOrCreateServerVoiceChannel(channel);
            ServerChannelCreateEventImpl event = new ServerChannelCreateEventImpl(voiceChannel);
            this.api.getEventDispatcher().dispatchServerChannelCreateEvent((DispatchQueueSelector)((Object)server), (Server)server, (ServerChannelCreateEvent)event);
        });
    }

    private void handlePrivateChannel(JsonNode channel) {
        UserImpl recipient = (UserImpl)this.api.getOrCreateUser(channel.get("recipients").get(0));
        if (!recipient.getPrivateChannel().isPresent()) {
            PrivateChannel privateChannel = recipient.getOrCreateChannel(channel);
            PrivateChannelCreateEventImpl event = new PrivateChannelCreateEventImpl(privateChannel);
            this.api.getEventDispatcher().dispatchPrivateChannelCreateEvent((DispatchQueueSelector)this.api, recipient, (PrivateChannelCreateEvent)event);
        }
    }

    private void handleGroupChannel(JsonNode channel) {
        long channelId = channel.get("id").asLong();
        if (!this.api.getGroupChannelById(channelId).isPresent()) {
            GroupChannelImpl groupChannel = new GroupChannelImpl(this.api, channel);
            GroupChannelCreateEventImpl event = new GroupChannelCreateEventImpl(groupChannel);
            this.api.getEventDispatcher().dispatchGroupChannelCreateEvent((DispatchQueueSelector)this.api, groupChannel.getMembers(), (GroupChannelCreateEvent)event);
        }
    }
}

