/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.javacord.api.AccountType;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordClient;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Region;
import org.javacord.api.entity.auditlog.AuditLog;
import org.javacord.api.entity.auditlog.AuditLogActionType;
import org.javacord.api.entity.auditlog.AuditLogEntry;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.emoji.KnownCustomEmoji;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Ban;
import org.javacord.api.entity.server.DefaultMessageNotificationLevel;
import org.javacord.api.entity.server.ExplicitContentFilterLevel;
import org.javacord.api.entity.server.MultiFactorAuthenticationLevel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.VerificationLevel;
import org.javacord.api.entity.server.invite.RichInvite;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.api.entity.webhook.Webhook;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.IconImpl;
import org.javacord.core.entity.activity.ActivityImpl;
import org.javacord.core.entity.auditlog.AuditLogImpl;
import org.javacord.core.entity.channel.ChannelCategoryImpl;
import org.javacord.core.entity.channel.ServerTextChannelImpl;
import org.javacord.core.entity.channel.ServerVoiceChannelImpl;
import org.javacord.core.entity.permission.RoleImpl;
import org.javacord.core.entity.server.BanImpl;
import org.javacord.core.entity.server.invite.InviteImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.entity.webhook.WebhookImpl;
import org.javacord.core.listener.server.InternalServerAttachableListenerManager;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;
import org.javacord.core.util.rest.RestRequestResult;

public class ServerImpl
implements Server,
Cleanupable,
InternalServerAttachableListenerManager,
DispatchQueueSelector {
    private static final Logger logger = LoggerUtil.getLogger(ServerImpl.class);
    private final DiscordApiImpl api;
    private final long id;
    private volatile String name;
    private volatile Region region;
    private final boolean large;
    private volatile long ownerId;
    private volatile long applicationId = -1L;
    private volatile VerificationLevel verificationLevel;
    private volatile ExplicitContentFilterLevel explicitContentFilterLevel;
    private volatile DefaultMessageNotificationLevel defaultMessageNotificationLevel;
    private volatile MultiFactorAuthenticationLevel multiFactorAuthenticationLevel;
    private final AtomicInteger memberCount = new AtomicInteger();
    private volatile String iconHash;
    private volatile String splash;
    private volatile long systemChannelId = -1L;
    private volatile long afkChannelId = -1L;
    private volatile int afkTimeout = 0;
    private volatile boolean ready = false;
    private final List<Consumer<Server>> readyConsumers = new ArrayList<Consumer<Server>>();
    private final ConcurrentHashMap<Long, Role> roles = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ServerChannel> channels = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, User> members = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, String> nicknames = new ConcurrentHashMap();
    private final Set<Long> selfMuted = new ConcurrentSkipListSet<Long>();
    private final Set<Long> selfDeafened = new ConcurrentSkipListSet<Long>();
    private final Set<Long> muted = new ConcurrentSkipListSet<Long>();
    private final Set<Long> deafened = new ConcurrentSkipListSet<Long>();
    private final ConcurrentHashMap<Long, Instant> joinedAtTimestamps = new ConcurrentHashMap();
    private final Collection<KnownCustomEmoji> customEmojis = new ArrayList<KnownCustomEmoji>();

    public ServerImpl(DiscordApiImpl api, JsonNode data) {
        this.api = api;
        this.id = Long.parseLong(data.get("id").asText());
        this.name = data.get("name").asText();
        this.region = Region.getRegionByKey(data.get("region").asText());
        this.large = data.get("large").asBoolean();
        this.memberCount.set(data.get("member_count").asInt());
        this.ownerId = Long.parseLong(data.get("owner_id").asText());
        this.verificationLevel = VerificationLevel.fromId(data.get("verification_level").asInt());
        this.explicitContentFilterLevel = ExplicitContentFilterLevel.fromId(data.get("explicit_content_filter").asInt());
        this.defaultMessageNotificationLevel = DefaultMessageNotificationLevel.fromId(data.get("default_message_notifications").asInt());
        this.multiFactorAuthenticationLevel = MultiFactorAuthenticationLevel.fromId(data.get("mfa_level").asInt());
        if (data.has("icon") && !data.get("icon").isNull()) {
            this.iconHash = data.get("icon").asText();
        }
        if (data.has("splash") && !data.get("splash").isNull()) {
            this.splash = data.get("splash").asText();
        }
        if (data.hasNonNull("afk_channel_id")) {
            this.afkChannelId = data.get("afk_channel_id").asLong();
        }
        if (data.hasNonNull("afk_timeout")) {
            this.afkTimeout = data.get("afk_timeout").asInt();
        }
        if (data.hasNonNull("system_channel_id")) {
            this.systemChannelId = data.get("system_channel_id").asLong();
        }
        if (data.hasNonNull("application_id")) {
            this.applicationId = data.get("application_id").asLong();
        }
        if (data.has("channels")) {
            block7: for (JsonNode channel : data.get("channels")) {
                switch (ChannelType.fromId(channel.get("type").asInt())) {
                    case SERVER_TEXT_CHANNEL: {
                        this.getOrCreateServerTextChannel(channel);
                        continue block7;
                    }
                    case SERVER_VOICE_CHANNEL: {
                        this.getOrCreateServerVoiceChannel(channel);
                        continue block7;
                    }
                    case CHANNEL_CATEGORY: {
                        this.getOrCreateChannelCategory(channel);
                        continue block7;
                    }
                    case SERVER_NEWS_CHANNEL: {
                        logger.debug("{} has a news channel. In this Javacord version it is treated as a normal text channel!", (Object)this);
                        this.getOrCreateServerTextChannel(channel);
                        continue block7;
                    }
                    case SERVER_STORE_CHANNEL: {
                        logger.debug("{} has a store channel. These are not supported in this Javacord version and get ignored!", (Object)this);
                        continue block7;
                    }
                }
                logger.warn("Unknown or unexpected channel type. Your Javacord version might be outdated!");
            }
        }
        if (data.has("roles")) {
            for (JsonNode roleJson : data.get("roles")) {
                RoleImpl role = new RoleImpl(api, this, roleJson);
                this.roles.put(role.getId(), role);
            }
        }
        if (data.has("members")) {
            this.addMembers(data.get("members"));
        }
        if (data.hasNonNull("voice_states")) {
            for (JsonNode voiceStateJson : data.get("voice_states")) {
                ServerVoiceChannelImpl channel = (ServerVoiceChannelImpl)this.getVoiceChannelById(voiceStateJson.get("channel_id").asLong()).orElseThrow(AssertionError::new);
                channel.addConnectedUser(voiceStateJson.get("user_id").asLong());
            }
        }
        if ((this.isLarge() || api.getAccountType() == AccountType.CLIENT) && this.getMembers().size() < this.getMemberCount()) {
            api.getWebSocketAdapter().queueRequestGuildMembers(this);
        }
        if (data.has("emojis")) {
            for (JsonNode emojiJson : data.get("emojis")) {
                KnownCustomEmoji emoji = api.getOrCreateKnownCustomEmoji(this, emojiJson);
                this.addCustomEmoji(emoji);
            }
        }
        if (data.has("presences")) {
            for (JsonNode presenceJson : data.get("presences")) {
                long userId = Long.parseLong(presenceJson.get("user").get("id").asText());
                UserImpl user = api.getCachedUserById(userId).map(UserImpl.class::cast).orElse(null);
                if (user == null) {
                    logger.debug("Found rogue presence. Ignoring it. ({})", (Object)presenceJson);
                    continue;
                }
                if (presenceJson.has("game")) {
                    ActivityImpl activity = null;
                    if (!presenceJson.get("game").isNull()) {
                        activity = new ActivityImpl(presenceJson.get("game"));
                    }
                    user.setActivity(activity);
                }
                if (presenceJson.has("status")) {
                    UserStatus status = UserStatus.fromString(presenceJson.get("status").asText());
                    user.setStatus(status);
                }
                if (!presenceJson.has("client_status")) continue;
                JsonNode clientStatus = presenceJson.get("client_status");
                for (DiscordClient client : DiscordClient.values()) {
                    if (clientStatus.hasNonNull(client.getName())) {
                        user.setClientStatus(client, UserStatus.fromString(clientStatus.get(client.getName()).asText()));
                        continue;
                    }
                    user.setClientStatus(client, UserStatus.OFFLINE);
                }
            }
        }
        api.addServerToCache(this);
    }

    public boolean isReady() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerReadyConsumer(Consumer<Server> consumer) {
        List<Consumer<Server>> list = this.readyConsumers;
        synchronized (list) {
            if (this.ready) {
                consumer.accept(this);
            } else {
                this.readyConsumers.add(consumer);
            }
        }
    }

    public String getIconHash() {
        return this.iconHash;
    }

    public void setIconHash(String iconHash) {
        this.iconHash = iconHash;
    }

    public String getSplashHash() {
        return this.splash;
    }

    public void setSplashHash(String splashHash) {
        this.splash = splashHash;
    }

    public void setSystemChannelId(long systemChannelId) {
        this.systemChannelId = systemChannelId;
    }

    public void setAfkChannelId(long afkChannelId) {
        this.afkChannelId = afkChannelId;
    }

    public void setAfkTimeout(int afkTimeout) {
        this.afkTimeout = afkTimeout;
    }

    public void setVerificationLevel(VerificationLevel verificationLevel) {
        this.verificationLevel = verificationLevel;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setDefaultMessageNotificationLevel(DefaultMessageNotificationLevel defaultMessageNotificationLevel) {
        this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
    }

    public void setOwnerId(long ownerId) {
        this.ownerId = ownerId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public void setExplicitContentFilterLevel(ExplicitContentFilterLevel explicitContentFilterLevel) {
        this.explicitContentFilterLevel = explicitContentFilterLevel;
    }

    public void setMultiFactorAuthenticationLevel(MultiFactorAuthenticationLevel multiFactorAuthenticationLevel) {
        this.multiFactorAuthenticationLevel = multiFactorAuthenticationLevel;
    }

    public void addChannelToCache(ServerChannel channel) {
        ServerChannel oldChannel = this.channels.put(channel.getId(), channel);
        if (oldChannel instanceof Cleanupable && oldChannel != channel) {
            ((Cleanupable)((Object)oldChannel)).cleanup();
        }
    }

    public void removeChannelFromCache(long channelId) {
        this.channels.computeIfPresent(channelId, (key, channel) -> {
            if (channel instanceof Cleanupable) {
                ((Cleanupable)((Object)channel)).cleanup();
            }
            return null;
        });
    }

    public void removeRole(long roleId) {
        this.roles.remove(roleId);
    }

    public void addCustomEmoji(KnownCustomEmoji emoji) {
        this.customEmojis.add(emoji);
    }

    public void removeCustomEmoji(KnownCustomEmoji emoji) {
        this.customEmojis.remove(emoji);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role getOrCreateRole(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        ServerImpl serverImpl = this;
        synchronized (serverImpl) {
            return this.getRoleById(id).orElseGet(() -> {
                RoleImpl role = new RoleImpl(this.api, this, data);
                this.roles.put(role.getId(), role);
                return role;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelCategory getOrCreateChannelCategory(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        ChannelType type = ChannelType.fromId(data.get("type").asInt());
        ServerImpl serverImpl = this;
        synchronized (serverImpl) {
            if (type == ChannelType.CHANNEL_CATEGORY) {
                return this.getChannelCategoryById(id).orElseGet(() -> new ChannelCategoryImpl(this.api, this, data));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTextChannel getOrCreateServerTextChannel(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        ChannelType type = ChannelType.fromId(data.get("type").asInt());
        ServerImpl serverImpl = this;
        synchronized (serverImpl) {
            if (type == ChannelType.SERVER_TEXT_CHANNEL || type == ChannelType.SERVER_NEWS_CHANNEL) {
                return this.getTextChannelById(id).orElseGet(() -> new ServerTextChannelImpl(this.api, this, data));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerVoiceChannel getOrCreateServerVoiceChannel(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        ChannelType type = ChannelType.fromId(data.get("type").asInt());
        ServerImpl serverImpl = this;
        synchronized (serverImpl) {
            if (type == ChannelType.SERVER_VOICE_CHANNEL) {
                return this.getVoiceChannelById(id).orElseGet(() -> new ServerVoiceChannelImpl(this.api, this, data));
            }
        }
        return null;
    }

    public void removeMember(User user) {
        long userId = user.getId();
        this.members.remove(userId);
        this.nicknames.remove(userId);
        this.selfMuted.remove(userId);
        this.selfDeafened.remove(userId);
        this.muted.remove(userId);
        this.deafened.remove(userId);
        this.getRoles().forEach(role -> ((RoleImpl)role).removeUserFromCache(user));
        this.joinedAtTimestamps.remove(userId);
    }

    public void decrementMemberCount() {
        this.memberCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(JsonNode member) {
        User user = this.api.getOrCreateUser(member.get("user"));
        this.members.put(user.getId(), user);
        if (member.hasNonNull("nick")) {
            this.nicknames.put(user.getId(), member.get("nick").asText());
        }
        if (member.hasNonNull("mute")) {
            this.setMuted(user.getId(), member.get("mute").asBoolean());
        }
        if (member.hasNonNull("deaf")) {
            this.setDeafened(user.getId(), member.get("deaf").asBoolean());
        }
        for (JsonNode roleIds : member.get("roles")) {
            long roleId = Long.parseLong(roleIds.asText());
            this.getRoleById(roleId).map(role -> (RoleImpl)role).ifPresent(role -> role.addUserToCache(user));
        }
        this.joinedAtTimestamps.put(user.getId(), OffsetDateTime.parse(member.get("joined_at").asText()).toInstant());
        List<Consumer<Server>> list = this.readyConsumers;
        synchronized (list) {
            if (!this.ready && this.members.size() == this.getMemberCount()) {
                this.ready = true;
                this.readyConsumers.forEach(consumer -> consumer.accept(this));
                this.readyConsumers.clear();
            }
        }
    }

    public void incrementMemberCount() {
        this.memberCount.incrementAndGet();
    }

    public void setNickname(User user, String nickname) {
        this.nicknames.compute(user.getId(), (key, value) -> nickname);
    }

    public void setSelfMuted(long userId, boolean muted) {
        if (muted) {
            this.selfMuted.add(userId);
        } else {
            this.selfMuted.remove(userId);
        }
    }

    public void setSelfDeafened(long userId, boolean deafened) {
        if (deafened) {
            this.selfDeafened.add(userId);
        } else {
            this.selfDeafened.remove(userId);
        }
    }

    public void setMuted(long userId, boolean muted) {
        if (muted) {
            this.muted.add(userId);
        } else {
            this.muted.remove(userId);
        }
    }

    public void setDeafened(long userId, boolean deafened) {
        if (deafened) {
            this.deafened.add(userId);
        } else {
            this.deafened.remove(userId);
        }
    }

    public void addMembers(JsonNode members) {
        for (JsonNode member : members) {
            this.addMember(member);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<ServerChannel> getUnorderedChannels() {
        return this.channels.values();
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public Optional<String> getNickname(User user) {
        return Optional.ofNullable(this.nicknames.get(user.getId()));
    }

    @Override
    public boolean isSelfMuted(long userId) {
        return this.selfMuted.contains(userId);
    }

    @Override
    public boolean isSelfDeafened(long userId) {
        return this.selfDeafened.contains(userId);
    }

    @Override
    public boolean isMuted(long userId) {
        return this.muted.contains(userId);
    }

    @Override
    public boolean isDeafened(long userId) {
        return this.deafened.contains(userId);
    }

    @Override
    public Optional<Instant> getJoinedAtTimestamp(User user) {
        return Optional.ofNullable(this.joinedAtTimestamps.get(user.getId()));
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public int getMemberCount() {
        return this.memberCount.get();
    }

    @Override
    public User getOwner() {
        return this.api.getCachedUserById(this.ownerId).orElseThrow(() -> new IllegalStateException("Owner of server " + this.toString() + " is not cached!"));
    }

    @Override
    public Optional<Long> getApplicationId() {
        return this.applicationId != -1L ? Optional.of(this.applicationId) : Optional.empty();
    }

    @Override
    public VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public ExplicitContentFilterLevel getExplicitContentFilterLevel() {
        return this.explicitContentFilterLevel;
    }

    @Override
    public DefaultMessageNotificationLevel getDefaultMessageNotificationLevel() {
        return this.defaultMessageNotificationLevel;
    }

    @Override
    public MultiFactorAuthenticationLevel getMultiFactorAuthenticationLevel() {
        return this.multiFactorAuthenticationLevel;
    }

    @Override
    public Optional<Icon> getIcon() {
        if (this.iconHash == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new IconImpl(this.getApi(), new URL("https://cdn.discordapp.com/icons/" + this.getIdAsString() + "/" + this.iconHash + ".png")));
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the icon is malformed! Please contact the developer!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Icon> getSplash() {
        if (this.splash == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new IconImpl(this.getApi(), new URL("https://cdn.discordapp.com/splashes/" + this.getIdAsString() + "/" + this.splash + ".png")));
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the icon is malformed! Please contact the developer!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ServerTextChannel> getSystemChannel() {
        return this.getTextChannelById(this.systemChannelId);
    }

    @Override
    public Optional<ServerVoiceChannel> getAfkChannel() {
        return this.getVoiceChannelById(this.afkChannelId);
    }

    @Override
    public int getAfkTimeoutInSeconds() {
        return this.afkTimeout;
    }

    @Override
    public CompletableFuture<Integer> getPruneCount(int days) {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.SERVER_PRUNE).setUrlParameters(this.getIdAsString()).addQueryParameter("days", String.valueOf(days)).execute(result -> result.getJsonBody().get("pruned").asInt());
    }

    @Override
    public CompletableFuture<Integer> pruneMembers(int days, String reason) {
        return new RestRequest(this.getApi(), RestMethod.POST, RestEndpoint.SERVER_PRUNE).setUrlParameters(this.getIdAsString()).addQueryParameter("days", String.valueOf(days)).setAuditLogReason(reason).execute(result -> result.getJsonBody().get("pruned").asInt());
    }

    @Override
    public CompletableFuture<Collection<RichInvite>> getInvites() {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.SERVER_INVITE).setUrlParameters(this.getIdAsString()).execute(result -> {
            HashSet<InviteImpl> invites = new HashSet<InviteImpl>();
            for (JsonNode inviteJson : result.getJsonBody()) {
                invites.add(new InviteImpl(this.getApi(), inviteJson));
            }
            return Collections.unmodifiableCollection(invites);
        });
    }

    @Override
    public Collection<User> getMembers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.members.values()));
    }

    @Override
    public Optional<User> getMemberById(long id) {
        return Optional.ofNullable(this.members.get(id));
    }

    @Override
    public boolean isMember(User user) {
        return this.members.containsKey(user.getId());
    }

    @Override
    public List<Role> getRoles() {
        return Collections.unmodifiableList(this.roles.values().stream().sorted(Comparator.comparingInt(Role::getPosition)).collect(Collectors.toList()));
    }

    @Override
    public Optional<Role> getRoleById(long id) {
        return Optional.ofNullable(this.roles.get(id));
    }

    @Override
    public CompletableFuture<Void> delete() {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.SERVER).setUrlParameters(this.getIdAsString()).execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> leave() {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.SERVER_SELF).setUrlParameters(this.getIdAsString()).execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> addRoleToUser(User user, Role role, String reason) {
        return new RestRequest(this.getApi(), RestMethod.PUT, RestEndpoint.SERVER_MEMBER_ROLE).setUrlParameters(this.getIdAsString(), user.getIdAsString(), role.getIdAsString()).setAuditLogReason(reason).execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> removeRoleFromUser(User user, Role role, String reason) {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.SERVER_MEMBER_ROLE).setUrlParameters(this.getIdAsString(), user.getIdAsString(), role.getIdAsString()).setAuditLogReason(reason).execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> reorderRoles(List<Role> roles, String reason) {
        roles = new ArrayList<Role>(roles);
        ArrayNode body = JsonNodeFactory.instance.arrayNode();
        roles.removeIf(Role::isEveryoneRole);
        for (int i = 0; i < roles.size(); ++i) {
            body.addObject().put("id", roles.get(i).getIdAsString()).put("position", i + 1);
        }
        return new RestRequest(this.getApi(), RestMethod.PATCH, RestEndpoint.ROLE).setUrlParameters(this.getIdAsString()).setBody(body).setAuditLogReason(reason).execute(result -> null);
    }

    @Override
    public void selfMute() {
        this.api.getWebSocketAdapter().sendVoiceStateUpdate(this, this.getConnectedVoiceChannel(this.api.getYourself()).orElse(null), true, null);
    }

    @Override
    public void selfUnmute() {
        this.api.getWebSocketAdapter().sendVoiceStateUpdate(this, this.getConnectedVoiceChannel(this.api.getYourself()).orElse(null), false, null);
    }

    @Override
    public void selfDeafen() {
        this.api.getWebSocketAdapter().sendVoiceStateUpdate(this, this.getConnectedVoiceChannel(this.api.getYourself()).orElse(null), null, true);
    }

    @Override
    public void selfUndeafen() {
        this.api.getWebSocketAdapter().sendVoiceStateUpdate(this, this.getConnectedVoiceChannel(this.api.getYourself()).orElse(null), null, false);
    }

    @Override
    public CompletableFuture<Void> kickUser(User user, String reason) {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.SERVER_MEMBER).setUrlParameters(this.getIdAsString(), user.getIdAsString()).setAuditLogReason(reason).execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> banUser(User user, int deleteMessageDays, String reason) {
        RestRequest<Void> request = new RestRequest(this.getApi(), RestMethod.PUT, RestEndpoint.BAN).setUrlParameters(this.getIdAsString(), user.getIdAsString()).addQueryParameter("delete-message-days", String.valueOf(deleteMessageDays));
        if (reason != null) {
            request.addQueryParameter("reason", reason);
        }
        return request.execute(result -> null);
    }

    @Override
    public CompletableFuture<Void> unbanUser(long userId, String reason) {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.BAN).setUrlParameters(this.getIdAsString(), Long.toUnsignedString(userId)).setAuditLogReason(reason).execute(result -> null);
    }

    @Override
    public CompletableFuture<Collection<Ban>> getBans() {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.BAN).setUrlParameters(this.getIdAsString()).execute(result -> {
            ArrayList<BanImpl> bans = new ArrayList<BanImpl>();
            for (JsonNode ban : result.getJsonBody()) {
                bans.add(new BanImpl(this, ban));
            }
            return Collections.unmodifiableCollection(bans);
        });
    }

    @Override
    public CompletableFuture<List<Webhook>> getWebhooks() {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.SERVER_WEBHOOK).setUrlParameters(this.getIdAsString()).execute(result -> {
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>();
            for (JsonNode webhookJson : result.getJsonBody()) {
                webhooks.add(new WebhookImpl(this.getApi(), webhookJson));
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    public CompletableFuture<AuditLog> getAuditLog(int limit) {
        return this.getAuditLogBefore(limit, null, null);
    }

    @Override
    public CompletableFuture<AuditLog> getAuditLog(int limit, AuditLogActionType type) {
        return this.getAuditLogBefore(limit, null, type);
    }

    @Override
    public CompletableFuture<AuditLog> getAuditLogBefore(int limit, AuditLogEntry before) {
        return this.getAuditLogBefore(limit, before, null);
    }

    @Override
    public CompletableFuture<AuditLog> getAuditLogBefore(int limit, AuditLogEntry before, AuditLogActionType type) {
        CompletableFuture<AuditLog> future = new CompletableFuture<AuditLog>();
        this.api.getThreadPool().getExecutorService().submit(() -> {
            try {
                AuditLogImpl auditLog = new AuditLogImpl(this);
                boolean requestMore = true;
                while (requestMore) {
                    int requestAmount = limit - auditLog.getEntries().size();
                    requestAmount = requestAmount > 100 ? 100 : requestAmount;
                    RestRequest<JsonNode> request = new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.AUDIT_LOG).setUrlParameters(this.getIdAsString()).addQueryParameter("limit", String.valueOf(requestAmount));
                    List<AuditLogEntry> lastAuditLogEntries = auditLog.getEntries();
                    if (!lastAuditLogEntries.isEmpty()) {
                        request.addQueryParameter("before", lastAuditLogEntries.get(lastAuditLogEntries.size() - 1).getIdAsString());
                    } else if (before != null) {
                        request.addQueryParameter("before", before.getIdAsString());
                    }
                    if (type != null) {
                        request.addQueryParameter("action_type", String.valueOf(type.getValue()));
                    }
                    JsonNode data = request.execute(RestRequestResult::getJsonBody).join();
                    auditLog.addEntries(data);
                    requestMore = auditLog.getEntries().size() < limit && data.get("audit_log_entries").size() >= requestAmount;
                }
                future.complete(auditLog);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @Override
    public Collection<KnownCustomEmoji> getCustomEmojis() {
        return Collections.unmodifiableCollection(new ArrayList<KnownCustomEmoji>(this.customEmojis));
    }

    @Override
    public List<ServerChannel> getChannels() {
        List channels = this.channels.values().stream().filter(channel -> channel.asCategorizable().map(categorizable -> !categorizable.getCategory().isPresent()).orElse(false)).sorted(Comparator.comparingInt(channel -> channel.getType().getId()).thenComparingInt(ServerChannel::getRawPosition).thenComparingLong(DiscordEntity::getId)).collect(Collectors.toList());
        this.getChannelCategories().forEach(category -> {
            channels.add(category);
            channels.addAll(category.getChannels());
        });
        return Collections.unmodifiableList(channels);
    }

    @Override
    public List<ChannelCategory> getChannelCategories() {
        return Collections.unmodifiableList(this.getUnorderedChannels().stream().filter(channel -> channel instanceof ChannelCategory).sorted(Comparator.comparingInt(ServerChannel::getRawPosition).thenComparingLong(DiscordEntity::getId)).map(channel -> (ChannelCategory)channel).collect(Collectors.toList()));
    }

    @Override
    public List<ServerTextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getUnorderedChannels().stream().filter(channel -> channel instanceof ServerTextChannel).sorted(Comparator.comparingInt(ServerChannel::getRawPosition).thenComparingLong(DiscordEntity::getId)).map(channel -> (ServerTextChannel)channel).collect(Collectors.toList()));
    }

    @Override
    public List<ServerVoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getUnorderedChannels().stream().filter(channel -> channel instanceof ServerVoiceChannel).sorted(Comparator.comparingInt(ServerChannel::getRawPosition).thenComparingLong(DiscordEntity::getId)).map(channel -> (ServerVoiceChannel)channel).collect(Collectors.toList()));
    }

    @Override
    public Optional<ServerChannel> getChannelById(long id) {
        return Optional.ofNullable(this.channels.get(id));
    }

    @Override
    public void cleanup() {
        this.channels.values().stream().map(DiscordEntity::getId).forEach(this.api::removeChannelFromCache);
        this.channels.values().stream().filter(Cleanupable.class::isInstance).map(Cleanupable.class::cast).forEach(Cleanupable::cleanup);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("Server (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

