/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.core.entity.user.UserImpl;

public class MessageAuthorImpl
implements MessageAuthor {
    private final Message message;
    private final Long webhookId;
    private final long id;
    private final String name;
    private final String discriminator;
    private final String avatarId;

    public MessageAuthorImpl(Message message, Long webhookId, JsonNode data) {
        this.message = message;
        this.id = data.get("id").asLong();
        this.name = data.get("username").asText();
        this.discriminator = data.get("discriminator").asText();
        this.avatarId = data.has("avatar") && !data.get("avatar").isNull() ? data.get("avatar").asText() : null;
        this.webhookId = webhookId;
    }

    @Override
    public DiscordApi getApi() {
        return this.message.getApi();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getDiscriminator() {
        return this.isUser() ? Optional.of(this.discriminator) : Optional.empty();
    }

    @Override
    public Icon getAvatar() {
        return UserImpl.getAvatar(this.message.getApi(), this.avatarId, this.discriminator, this.id);
    }

    @Override
    public boolean isUser() {
        return this.webhookId == null;
    }

    @Override
    public boolean isWebhook() {
        return this.webhookId != null;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("MessageAuthor (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

