/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAttachment;
import org.javacord.core.util.FileContainer;
import org.javacord.core.util.logging.LoggerUtil;

public class MessageAttachmentImpl
implements MessageAttachment {
    private static final Logger logger = LoggerUtil.getLogger(MessageAttachmentImpl.class);
    private final long id;
    private final Message message;
    private final String fileName;
    private final int size;
    private final String url;
    private final String proxyUrl;
    private final Integer height;
    private final Integer width;

    public MessageAttachmentImpl(Message message, JsonNode data) {
        this.message = message;
        this.id = data.get("id").asLong();
        this.fileName = data.get("filename").asText();
        this.size = data.get("size").asInt();
        this.url = data.get("url").asText();
        this.proxyUrl = data.get("proxy_url").asText();
        this.height = data.has("height") && !data.get("height").isNull() ? Integer.valueOf(data.get("height").asInt()) : null;
        this.width = data.has("width") && !data.get("width").isNull() ? Integer.valueOf(data.get("width").asInt()) : null;
    }

    @Override
    public DiscordApi getApi() {
        return this.message.getApi();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public URL getUrl() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the attachment is malformed! Please contact the developer!", (Throwable)e);
            return null;
        }
    }

    @Override
    public URL getProxyUrl() {
        try {
            return new URL(this.proxyUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the proxy url of the attachment is malformed! Please contact the developer!", (Throwable)e);
            return null;
        }
    }

    @Override
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(this.height);
    }

    @Override
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(this.width);
    }

    @Override
    public CompletableFuture<byte[]> downloadAsByteArray() {
        return new FileContainer(this.getUrl()).asByteArray(this.getApi());
    }

    @Override
    public CompletableFuture<BufferedImage> downloadAsImage() {
        return new FileContainer(this.getUrl()).asBufferedImage(this.getApi());
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("MessageAttachment (file name: %s, url: %s)", this.getFileName(), this.getUrl().toString());
    }
}

