/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.channel.ServerChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.listener.channel.server.voice.InternalServerVoiceChannelAttachableListenerManager;

public class ServerVoiceChannelImpl
extends ServerChannelImpl
implements ServerVoiceChannel,
InternalServerVoiceChannelAttachableListenerManager {
    private volatile int bitrate;
    private volatile int userLimit;
    private volatile long parentId;
    private final Collection<Long> connectedUsers = new ArrayList<Long>();

    public ServerVoiceChannelImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        super(api, server, data);
        this.bitrate = data.get("bitrate").asInt();
        this.userLimit = data.get("user_limit").asInt();
        this.parentId = Long.valueOf(data.has("parent_id") ? data.get("parent_id").asText("-1") : "-1");
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void addConnectedUser(long userId) {
        this.connectedUsers.add(userId);
    }

    public void removeConnectedUser(long userId) {
        this.connectedUsers.remove(userId);
    }

    @Override
    public Optional<ChannelCategory> getCategory() {
        return this.getServer().getChannelCategoryById(this.parentId);
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public Optional<Integer> getUserLimit() {
        return this.userLimit == 0 ? Optional.empty() : Optional.of(this.userLimit);
    }

    @Override
    public Collection<Long> getConnectedUserIds() {
        return Collections.unmodifiableCollection(this.connectedUsers);
    }

    @Override
    public Collection<User> getConnectedUsers() {
        return Collections.unmodifiableCollection(this.connectedUsers.stream().map(this.getApi()::getCachedUserById).map(optionalUser -> (User)optionalUser.orElseThrow(AssertionError::new)).collect(Collectors.toList()));
    }

    @Override
    public boolean isConnected(long userId) {
        return this.connectedUsers.contains(userId);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public String toString() {
        return String.format("ServerVoiceChannel (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

