/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.activity;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.ApplicationInfo;
import org.javacord.api.entity.user.User;

public class ApplicationInfoImpl
implements ApplicationInfo {
    private final DiscordApi api;
    private final long clientId;
    private final String name;
    private final String description;
    private final boolean publicBot;
    private final boolean botRequiresCodeGrant;
    private final long ownerId;
    private final String ownerName;
    private final String ownerDiscriminator;

    public ApplicationInfoImpl(DiscordApi api, JsonNode data) {
        this.api = api;
        this.clientId = data.get("id").asLong();
        this.name = data.get("name").asText();
        this.description = data.get("description").asText();
        this.publicBot = data.get("bot_public").asBoolean();
        this.botRequiresCodeGrant = data.get("bot_require_code_grant").asBoolean();
        this.ownerId = data.get("owner").get("id").asLong();
        this.ownerName = data.get("owner").get("username").asText();
        this.ownerDiscriminator = data.get("owner").get("discriminator").asText();
    }

    @Override
    public long getClientId() {
        return this.clientId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPublicBot() {
        return this.publicBot;
    }

    @Override
    public boolean botRequiresCodeGrant() {
        return this.botRequiresCodeGrant;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public long getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getOwnerDiscriminator() {
        return this.ownerDiscriminator;
    }

    @Override
    public CompletableFuture<User> getOwner() {
        return this.api.getUserById(this.getOwnerId());
    }
}

