/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.discordbot.cmd;

import com.regdrasil.discordbot.Main;
import com.regdrasil.discordbot.cmd.Command;
import com.regdrasil.discordbot.cmd.CommandListener;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.event.message.MessageCreateEvent;

@Command(triggers={Command.Trigger.MENTION, Command.Trigger.PRIVATE_MESSAGE}, helpSection="General", help={"**help** : Show this help"})
public class HelpCommand
extends CommandListener {
    public static EmbedBuilder HELP = null;
    private static final Pattern PATTERN = Pattern.compile("(help|usage|guide|aide)", 2);
    private static final String HELP_ASSET = "https://cdn.discordapp.com/app-assets/596990103319216128/599263068941189152.png";
    private static BufferedImage HELP_ICON;

    @Override
    public boolean triggered(MessageCreateEvent event) {
        return PATTERN.matcher(event.getMessageContent()).find();
    }

    @Override
    public void action(MessageCreateEvent event) {
        if (HELP == null) {
            EmbedBuilder embedBuilder = new EmbedBuilder();
            embedBuilder.setAuthor("HELP", "", HELP_ICON);
            embedBuilder.setColor(new Color(31, 74, 143));
            for (Map.Entry<String, Map<String, String[]>> entry : Main.HELPS.entrySet()) {
                String section = entry.getKey();
                Map<String, String[]> commands = entry.getValue();
                StringBuilder sb = new StringBuilder();
                Iterator<String[]> helpLinesIterator = commands.values().iterator();
                while (helpLinesIterator.hasNext()) {
                    String[] helpLines = helpLinesIterator.next();
                    Iterator<String> iterator = Arrays.asList(helpLines).iterator();
                    while (iterator.hasNext()) {
                        sb.append("- ");
                        sb.append((Object)iterator.next());
                        if (!iterator.hasNext()) continue;
                        sb.append("\n");
                    }
                    if (!helpLinesIterator.hasNext()) continue;
                    sb.append("\n");
                }
                embedBuilder.addField(section, sb.toString());
            }
            HELP = embedBuilder;
        }
        event.getChannel().sendMessage(HELP);
    }

    static {
        try {
            HELP_ICON = ImageIO.read(HelpCommand.class.getResource("/discordbot/help.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(HelpCommand.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

