/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.message.MessageCreateEvent;
import org.javacord.core.event.message.MessageCreateEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class MessageCreateHandler
extends PacketHandler {
    public MessageCreateHandler(DiscordApi api) {
        super(api, true, "MESSAGE_CREATE");
    }

    @Override
    public void handle(JsonNode packet) {
        this.api.getTextChannelById(packet.get("channel_id").asText()).ifPresent(channel -> {
            Message message = this.api.getOrCreateMessage((TextChannel)channel, packet);
            MessageCreateEventImpl event = new MessageCreateEventImpl(message);
            Optional<Server> optionalServer = channel.asServerChannel().map(ServerChannel::getServer);
            this.api.getEventDispatcher().dispatchMessageCreateEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), (Server)optionalServer.orElse(null), (TextChannel)channel, message.getUserAuthor().orElse(null), (MessageCreateEvent)event);
        });
    }
}

