/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.guild;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.server.role.UserRoleAddEvent;
import org.javacord.api.event.server.role.UserRoleRemoveEvent;
import org.javacord.api.event.user.UserChangeNicknameEvent;
import org.javacord.core.entity.permission.RoleImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.event.server.role.UserRoleAddEventImpl;
import org.javacord.core.event.server.role.UserRoleRemoveEventImpl;
import org.javacord.core.event.user.UserChangeNicknameEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class GuildMemberUpdateHandler
extends PacketHandler {
    public GuildMemberUpdateHandler(DiscordApi api) {
        super(api, true, "GUILD_MEMBER_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        this.api.getPossiblyUnreadyServerById(packet.get("guild_id").asLong()).map(server -> (ServerImpl)server).ifPresent(server -> {
            String oldNickname;
            String newNickname;
            User user = this.api.getOrCreateUser(packet.get("user"));
            if (packet.has("nick") && !Objects.deepEquals(newNickname = packet.get("nick").asText(null), oldNickname = (String)server.getNickname(user).orElse(null))) {
                server.setNickname(user, newNickname);
                UserChangeNicknameEventImpl event = new UserChangeNicknameEventImpl(user, (Server)server, newNickname, oldNickname);
                this.api.getEventDispatcher().dispatchUserChangeNicknameEvent((DispatchQueueSelector)server, (Server)server, user, (UserChangeNicknameEvent)event);
            }
            if (packet.has("roles")) {
                JsonNode jsonRoles = packet.get("roles");
                HashSet newRoles = new HashSet();
                List<Role> oldRoles = server.getRoles(user);
                HashSet intersection = new HashSet();
                for (Object roleIdJson : jsonRoles) {
                    this.api.getRoleById(((JsonNode)roleIdJson).asText()).map(role -> {
                        newRoles.add(role);
                        return role;
                    }).filter(oldRoles::contains).ifPresent(intersection::add);
                }
                ArrayList addedRoles = new ArrayList(newRoles);
                addedRoles.removeAll(intersection);
                for (Role role2 : addedRoles) {
                    if (role2.isEveryoneRole()) continue;
                    ((RoleImpl)role2).addUserToCache(user);
                    UserRoleAddEventImpl event = new UserRoleAddEventImpl(role2, user);
                    this.api.getEventDispatcher().dispatchUserRoleAddEvent((DispatchQueueSelector)((Object)role2.getServer()), role2, role2.getServer(), user, (UserRoleAddEvent)event);
                }
                ArrayList<Role> removedRoles = new ArrayList<Role>(oldRoles);
                removedRoles.removeAll(intersection);
                for (Role role3 : removedRoles) {
                    if (role3.isEveryoneRole()) continue;
                    ((RoleImpl)role3).removeUserFromCache(user);
                    UserRoleRemoveEventImpl event = new UserRoleRemoveEventImpl(role3, user);
                    this.api.getEventDispatcher().dispatchUserRoleRemoveEvent((DispatchQueueSelector)((Object)role3.getServer()), role3, role3.getServer(), user, (UserRoleRemoveEvent)event);
                }
            }
            if (user.isYourself()) {
                Set unreadableChannels = server.getTextChannels().stream().filter(((Predicate<ServerTextChannel>)Channel::canYouSee).negate()).map(DiscordEntity::getId).collect(Collectors.toSet());
                this.api.forEachCachedMessageWhere(msg -> unreadableChannels.contains(msg.getChannel().getId()), msg -> this.api.removeMessageFromCache(msg.getId()));
            }
        });
    }
}

