/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.core.entity.channel.GroupChannelImpl;
import org.javacord.core.entity.channel.PrivateChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.logging.LoggerUtil;

public class ReadyHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ReadyHandler.class);

    public ReadyHandler(DiscordApi api) {
        super(api, false, "READY");
    }

    @Override
    public void handle(JsonNode packet) {
        this.api.purgeCache();
        JsonNode guilds = packet.get("guilds");
        for (JsonNode guildJson : guilds) {
            if (guildJson.has("unavailable") && guildJson.get("unavailable").asBoolean()) {
                this.api.addUnavailableServerToCache(guildJson.get("id").asLong());
                continue;
            }
            new ServerImpl(this.api, guildJson);
        }
        if (packet.has("private_channels")) {
            JsonNode privateChannels = packet.get("private_channels");
            block5: for (JsonNode channelJson : privateChannels) {
                switch (ChannelType.fromId(channelJson.get("type").asInt())) {
                    case PRIVATE_CHANNEL: {
                        new PrivateChannelImpl(this.api, channelJson);
                        continue block5;
                    }
                    case GROUP_CHANNEL: {
                        new GroupChannelImpl(this.api, channelJson);
                        continue block5;
                    }
                }
                logger.warn("Unknown or unexpected channel type. Your Javacord version might be out of date!");
            }
        }
        this.api.setYourself(this.api.getOrCreateUser(packet.get("user")));
    }
}

