/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.gateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.logging.log4j.Logger;
import org.javacord.api.entity.activity.Activity;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.util.auth.Request;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.event.connection.LostConnectionEventImpl;
import org.javacord.core.event.connection.ReconnectEventImpl;
import org.javacord.core.event.connection.ResumeEventImpl;
import org.javacord.core.util.auth.NvWebSocketResponseImpl;
import org.javacord.core.util.auth.NvWebSocketRouteImpl;
import org.javacord.core.util.concurrent.ThreadFactory;
import org.javacord.core.util.gateway.GatewayOpcode;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.gateway.WebSocketCloseCode;
import org.javacord.core.util.gateway.WebSocketCloseReason;
import org.javacord.core.util.handler.ReadyHandler;
import org.javacord.core.util.handler.ResumedHandler;
import org.javacord.core.util.handler.channel.ChannelCreateHandler;
import org.javacord.core.util.handler.channel.ChannelDeleteHandler;
import org.javacord.core.util.handler.channel.ChannelPinsUpdateHandler;
import org.javacord.core.util.handler.channel.ChannelUpdateHandler;
import org.javacord.core.util.handler.channel.WebhooksUpdateHandler;
import org.javacord.core.util.handler.guild.GuildBanAddHandler;
import org.javacord.core.util.handler.guild.GuildBanRemoveHandler;
import org.javacord.core.util.handler.guild.GuildCreateHandler;
import org.javacord.core.util.handler.guild.GuildDeleteHandler;
import org.javacord.core.util.handler.guild.GuildEmojisUpdateHandler;
import org.javacord.core.util.handler.guild.GuildMemberAddHandler;
import org.javacord.core.util.handler.guild.GuildMemberRemoveHandler;
import org.javacord.core.util.handler.guild.GuildMemberUpdateHandler;
import org.javacord.core.util.handler.guild.GuildMembersChunkHandler;
import org.javacord.core.util.handler.guild.GuildUpdateHandler;
import org.javacord.core.util.handler.guild.VoiceStateUpdateHandler;
import org.javacord.core.util.handler.guild.role.GuildRoleCreateHandler;
import org.javacord.core.util.handler.guild.role.GuildRoleDeleteHandler;
import org.javacord.core.util.handler.guild.role.GuildRoleUpdateHandler;
import org.javacord.core.util.handler.message.MessageCreateHandler;
import org.javacord.core.util.handler.message.MessageDeleteBulkHandler;
import org.javacord.core.util.handler.message.MessageDeleteHandler;
import org.javacord.core.util.handler.message.MessageUpdateHandler;
import org.javacord.core.util.handler.message.reaction.MessageReactionAddHandler;
import org.javacord.core.util.handler.message.reaction.MessageReactionRemoveAllHandler;
import org.javacord.core.util.handler.message.reaction.MessageReactionRemoveHandler;
import org.javacord.core.util.handler.user.PresenceUpdateHandler;
import org.javacord.core.util.handler.user.PresencesReplaceHandler;
import org.javacord.core.util.handler.user.TypingStartHandler;
import org.javacord.core.util.handler.user.UserUpdateHandler;
import org.javacord.core.util.http.TrustAllTrustManager;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.logging.WebSocketLogger;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class DiscordWebSocketAdapter
extends WebSocketAdapter {
    private static final Logger logger = LoggerUtil.getLogger(DiscordWebSocketAdapter.class);
    private static String gateway;
    private static final ReadWriteLock gatewayLock;
    private static final Lock gatewayReadLock;
    private static final Lock gatewayWriteLock;
    private final DiscordApiImpl api;
    private final HashMap<String, PacketHandler> handlers = new HashMap();
    private final CompletableFuture<Boolean> ready = new CompletableFuture();
    private final AtomicReference<WebSocket> websocket = new AtomicReference();
    private final AtomicReference<Future<?>> heartbeatTimer = new AtomicReference();
    private final AtomicBoolean heartbeatAckReceived = new AtomicBoolean();
    private volatile int lastSeq = -1;
    private volatile String sessionId = null;
    private volatile boolean reconnect;
    private final AtomicMarkableReference<WebSocketFrame> lastSentFrameWasIdentify = new AtomicMarkableReference<Object>(null, false);
    private final AtomicReference<WebSocketFrame> nextHeartbeatFrame = new AtomicReference<Object>(null);
    private final List<WebSocketListener> identifyFrameListeners = Collections.synchronizedList(new ArrayList());
    private volatile long lastGuildMembersChunkReceived = System.currentTimeMillis();
    private final AtomicInteger reconnectAttempt = new AtomicInteger();
    private final BlockingQueue<Long> requestGuildMembersQueue = new LinkedBlockingQueue<Long>();
    private static final Map<String, Long> lastIdentificationPerAccount;
    private static final ConcurrentMap<String, Semaphore> connectionDelaySemaphorePerAccount;

    public DiscordWebSocketAdapter(DiscordApiImpl api) {
        this(api, true);
    }

    DiscordWebSocketAdapter(DiscordApiImpl api, boolean reconnect) {
        this.api = api;
        this.reconnect = reconnect;
        this.registerHandlers();
        this.connect();
        ExecutorService requestGuildMembersQueueConsumer = api.getThreadPool().getSingleDaemonThreadExecutorService("Request Server Members Queue Consumer");
        requestGuildMembersQueueConsumer.submit(() -> {
            while (!requestGuildMembersQueueConsumer.isShutdown()) {
                try {
                    Long nextServerId = this.requestGuildMembersQueue.poll(1L, TimeUnit.MINUTES);
                    if (nextServerId == null) continue;
                    this.requestGuildMembersQueue.add(nextServerId);
                    AtomicInteger batchCounter = new AtomicInteger();
                    this.requestGuildMembersQueue.stream().distinct().collect(Collectors.groupingBy(serverId -> batchCounter.getAndIncrement() / 50)).values().forEach(serverIdBatch -> {
                        this.requestGuildMembersQueue.removeAll((Collection<?>)serverIdBatch);
                        ObjectNode requestGuildMembersPacket = JsonNodeFactory.instance.objectNode().put("op", GatewayOpcode.REQUEST_GUILD_MEMBERS.getCode());
                        ObjectNode data = requestGuildMembersPacket.putObject("d").put("query", "").put("limit", 0);
                        if (serverIdBatch.size() == 1) {
                            data.put("guild_id", Long.toUnsignedString((Long)serverIdBatch.get(0)));
                        } else {
                            ArrayNode guildIds = data.putArray("guild_id");
                            serverIdBatch.stream().map(Long::toUnsignedString).forEach(guildIds::add);
                        }
                        logger.debug("Sending request guild members packet {}", (Object)requestGuildMembersPacket);
                        this.getWebSocket().sendText(requestGuildMembersPacket.toString());
                    });
                    Thread.sleep(1000L);
                }
                catch (InterruptedException nextServerId) {
                }
                catch (Throwable t) {
                    logger.error("Failed to process request guild members queue!", t);
                }
            }
        });
    }

    private static String getGateway(DiscordApiImpl api) {
        gatewayReadLock.lock();
        if (gateway == null) {
            gatewayReadLock.unlock();
            gatewayWriteLock.lock();
            try {
                if (gateway == null) {
                    gateway = new RestRequest(api, RestMethod.GET, RestEndpoint.GATEWAY).includeAuthorizationHeader(false).execute(result -> result.getJsonBody().get("url").asText()).join();
                }
                gatewayReadLock.lock();
            }
            finally {
                gatewayWriteLock.unlock();
            }
        }
        try {
            String string = gateway;
            return string;
        }
        finally {
            gatewayReadLock.unlock();
        }
    }

    public static void setGateway(String gateway) {
        gatewayWriteLock.lock();
        try {
            DiscordWebSocketAdapter.gateway = gateway;
        }
        finally {
            gatewayWriteLock.unlock();
        }
    }

    public void disconnect() {
        this.reconnect = false;
        this.websocket.get().sendClose(WebSocketCloseReason.DISCONNECT.getNumericCloseCode());
        this.api.getThreadPool().getDaemonScheduler().schedule(() -> this.heartbeatTimer.updateAndGet(future -> {
            if (future != null) {
                future.cancel(false);
            }
            return null;
        }), 1L, TimeUnit.MINUTES);
    }

    private void connect() {
        block9: {
            try {
                WebSocketFactory factory = new WebSocketFactory();
                String webSocketUri = DiscordWebSocketAdapter.getGateway(this.api) + "?encoding=json&v=" + "6";
                Proxy proxy = this.api.getProxy().orElseGet(() -> {
                    List<Proxy> proxies = this.api.getProxySelector().orElseGet(ProxySelector::getDefault).select(URI.create(webSocketUri.replace("wss://", "https://").replace("ws://", "http://")));
                    return proxies.stream().filter(p -> p.type() == Proxy.Type.DIRECT).findAny().orElseGet(() -> proxies.stream().filter(p -> p.type() == Proxy.Type.HTTP).findAny().orElseGet(() -> (Proxy)proxies.get(0)));
                });
                switch (proxy.type()) {
                    case DIRECT: {
                        break;
                    }
                    case HTTP: {
                        SocketAddress proxyAddress = proxy.address();
                        if (!(proxyAddress instanceof InetSocketAddress)) {
                            throw new WebSocketException(null, "HTTP proxies without an InetSocketAddress are not supported currently");
                        }
                        InetSocketAddress proxyInetAddress = (InetSocketAddress)proxyAddress;
                        String proxyHost = proxyInetAddress.getHostString();
                        int proxyPort = proxyInetAddress.getPort();
                        ProxySettings proxySettings = factory.getProxySettings();
                        proxySettings.setHost(proxyHost).setPort(proxyPort);
                        Optional<org.javacord.api.util.auth.Authenticator> proxyAuthenticator = this.api.getProxyAuthenticator();
                        URL webSocketUrl = URI.create(webSocketUri.replace("wss://", "https://").replace("ws://", "http://")).toURL();
                        if (proxyAuthenticator.isPresent()) {
                            Map<String, List<String>> requestHeaders = proxyAuthenticator.get().authenticate(new NvWebSocketRouteImpl(webSocketUrl, proxy, proxyInetAddress), new Request(){}, new NvWebSocketResponseImpl());
                            if (requestHeaders == null) break;
                            requestHeaders.forEach((headerName, headerValues) -> {
                                if (headerValues == null) {
                                    proxySettings.getHeaders().remove(headerName);
                                    return;
                                }
                                if (headerValues.isEmpty()) {
                                    return;
                                }
                                String firstHeaderValue = (String)headerValues.get(0);
                                if (firstHeaderValue == null) {
                                    proxySettings.getHeaders().remove(headerName);
                                } else {
                                    proxySettings.addHeader((String)headerName, firstHeaderValue);
                                }
                                headerValues.stream().skip(1L).forEach(headerValue -> proxySettings.addHeader((String)headerName, (String)headerValue));
                            });
                            break;
                        }
                        PasswordAuthentication credentials = Authenticator.requestPasswordAuthentication(proxyHost, proxyInetAddress.getAddress(), proxyPort, webSocketUrl.getProtocol(), null, "Basic", webSocketUrl, Authenticator.RequestorType.PROXY);
                        if (credentials == null) break;
                        proxySettings.setId(credentials.getUserName()).setPassword(String.valueOf(credentials.getPassword()));
                        break;
                    }
                    default: {
                        throw new WebSocketException(null, "Proxies of type '" + (Object)((Object)proxy.type()) + "' are not supported currently");
                    }
                }
                if (this.api.isTrustAllCertificates()) {
                    factory.setSSLSocketFactory(new TrustAllTrustManager().createSslSocketFactory());
                }
                WebSocket websocket = factory.createSocket(webSocketUri);
                this.websocket.set(websocket);
                websocket.addHeader("Accept-Encoding", "gzip");
                websocket.addListener(this);
                websocket.addListener(new WebSocketLogger());
                this.waitForIdentifyRateLimit();
                websocket.connect();
            }
            catch (Throwable t) {
                logger.warn("An error occurred while connecting to websocket", t);
                if (!this.reconnect) break block9;
                this.reconnectAttempt.incrementAndGet();
                logger.info("Trying to reconnect/resume in {} seconds!", (Object)this.api.getReconnectDelay(this.reconnectAttempt.get()));
                this.api.getThreadPool().getScheduler().schedule(() -> {
                    gatewayWriteLock.lock();
                    try {
                        gateway = null;
                    }
                    finally {
                        gatewayWriteLock.unlock();
                    }
                    this.connect();
                }, (long)this.api.getReconnectDelay(this.reconnectAttempt.get()), TimeUnit.SECONDS);
            }
        }
    }

    private void waitForIdentifyRateLimit() {
        String token = this.api.getPrefixedToken();
        connectionDelaySemaphorePerAccount.computeIfAbsent(token, key -> new Semaphore(1)).acquireUninterruptibly();
        long delay = 5100L - (System.currentTimeMillis() - lastIdentificationPerAccount.getOrDefault(token, 0L));
        while (delay > 0L) {
            logger.debug("Delaying connecting by {}ms", (Object)delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delay = 5100L - (System.currentTimeMillis() - lastIdentificationPerAccount.getOrDefault(token, 0L));
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        Optional<WebSocketFrame> closeFrameOptional = Optional.ofNullable(closedByServer ? serverCloseFrame : clientCloseFrame);
        String closeReason = closeFrameOptional.map(WebSocketFrame::getCloseReason).orElse("unknown");
        String closeCodeString = closeFrameOptional.map(closeFrame -> {
            int code = closeFrame.getCloseCode();
            return WebSocketCloseCode.fromCode(code).map(closeCode -> (Object)closeCode + " (" + code + ")").orElseGet(() -> String.valueOf(code));
        }).orElse("'unknown'");
        logger.info("Websocket closed with reason '{}' and code {} by {}!", (Object)closeReason, (Object)closeCodeString, (Object)(closedByServer ? "server" : "client"));
        LostConnectionEventImpl lostConnectionEvent = new LostConnectionEventImpl(this.api);
        this.api.getEventDispatcher().dispatchLostConnectionEvent(null, lostConnectionEvent);
        this.heartbeatTimer.updateAndGet(future -> {
            if (future != null) {
                future.cancel(false);
            }
            return null;
        });
        if (!this.ready.isDone()) {
            this.ready.complete(false);
            return;
        }
        if (this.reconnect) {
            this.reconnectAttempt.incrementAndGet();
            logger.info("Trying to reconnect/resume in {} seconds!", (Object)this.api.getReconnectDelay(this.reconnectAttempt.get()));
            this.api.getThreadPool().getScheduler().schedule(this::connect, (long)this.api.getReconnectDelay(this.reconnectAttempt.get()), TimeUnit.SECONDS);
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String text) throws Exception {
        ObjectMapper mapper = this.api.getObjectMapper();
        JsonNode packet = mapper.readTree(text);
        int op = packet.get("op").asInt();
        Optional<GatewayOpcode> opcode = GatewayOpcode.fromCode(op);
        if (!opcode.isPresent()) {
            logger.debug("Received unknown packet (op: {}, content: {})", (Object)op, (Object)packet);
            return;
        }
        switch (opcode.get()) {
            case DISPATCH: {
                this.lastSeq = packet.get("s").asInt();
                String type = packet.get("t").asText();
                PacketHandler handler = this.handlers.get(type);
                if (handler != null) {
                    handler.handlePacket(packet.get("d"));
                } else {
                    logger.debug("Received unknown packet of type {} (packet: {})", (Object)type, (Object)packet);
                }
                if (type.equals("GUILD_MEMBERS_CHUNK")) {
                    this.lastGuildMembersChunkReceived = System.currentTimeMillis();
                }
                if (type.equals("RESUMED")) {
                    this.reconnectAttempt.set(0);
                    logger.debug("Received RESUMED packet");
                    ResumeEventImpl resumeEvent = new ResumeEventImpl(this.api);
                    this.api.getEventDispatcher().dispatchResumeEvent(null, resumeEvent);
                }
                if (!type.equals("READY")) break;
                this.reconnectAttempt.set(0);
                this.sessionId = packet.get("d").get("session_id").asText();
                this.api.getThreadPool().getSingleThreadExecutorService("Startup Servers Wait Thread").submit(() -> {
                    boolean allUsersLoaded = false;
                    boolean allServersLoaded = false;
                    int lastUnavailableServerAmount = 0;
                    int sameUnavailableServerCounter = 0;
                    while (!(!this.api.isWaitingForServersOnStartup() || allServersLoaded && allUsersLoaded)) {
                        if (this.api.getUnavailableServers().size() == lastUnavailableServerAmount) {
                            ++sameUnavailableServerCounter;
                        } else {
                            lastUnavailableServerAmount = this.api.getUnavailableServers().size();
                            sameUnavailableServerCounter = 0;
                        }
                        allServersLoaded = this.api.getUnavailableServers().isEmpty();
                        if (allServersLoaded) {
                            allUsersLoaded = this.api.getAllServers().stream().noneMatch(server -> server.getMemberCount() != server.getMembers().size());
                        }
                        if (sameUnavailableServerCounter > 1000 && this.lastGuildMembersChunkReceived + 5000L < System.currentTimeMillis()) break;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ReconnectEventImpl reconnectEvent = new ReconnectEventImpl(this.api);
                    this.api.getEventDispatcher().dispatchReconnectEvent(null, reconnectEvent);
                    this.ready.complete(true);
                });
                logger.debug("Received READY packet");
                break;
            }
            case HEARTBEAT: {
                this.sendHeartbeat(websocket);
                break;
            }
            case RECONNECT: {
                websocket.sendClose(WebSocketCloseReason.COMMANDED_RECONNECT.getNumericCloseCode(), WebSocketCloseReason.COMMANDED_RECONNECT.getCloseReason());
                break;
            }
            case INVALID_SESSION: {
                long fakeLastIdentificationTime = System.currentTimeMillis();
                if (this.lastSentFrameWasIdentify.isMarked()) {
                    logger.info("Hit identifying rate limit. Retrying in 5 seconds...");
                } else {
                    int zeroToFourSeconds = (int)(Math.random() * 4000.0);
                    logger.info("Could not resume session. Reconnecting in {}.{} seconds...", () -> 1 + zeroToFourSeconds / 1000, () -> 1 + zeroToFourSeconds / 100 % 10);
                    fakeLastIdentificationTime -= (long)(4000 - zeroToFourSeconds);
                }
                lastIdentificationPerAccount.put(this.api.getPrefixedToken(), fakeLastIdentificationTime);
                this.waitForIdentifyRateLimit();
                this.sendIdentify(websocket);
                break;
            }
            case HELLO: {
                logger.debug("Received HELLO packet");
                JsonNode data = packet.get("d");
                int heartbeatInterval = data.get("heartbeat_interval").asInt();
                this.heartbeatTimer.updateAndGet(future -> {
                    if (future != null) {
                        future.cancel(false);
                    }
                    return this.startHeartbeat(websocket, heartbeatInterval);
                });
                if (this.sessionId == null) {
                    this.sendIdentify(websocket);
                    break;
                }
                ((Semaphore)connectionDelaySemaphorePerAccount.get(this.api.getPrefixedToken())).release();
                this.sendResume(websocket);
                break;
            }
            case HEARTBEAT_ACK: {
                logger.debug("Heartbeat ACK received");
                this.heartbeatAckReceived.set(true);
                break;
            }
            default: {
                logger.debug("Received unknown packet (op: {}, content: {})", (Object)op, (Object)packet);
            }
        }
    }

    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
        Inflater decompressor = new Inflater();
        decompressor.setInput(binary);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binary.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count;
            try {
                count = decompressor.inflate(buf);
            }
            catch (DataFormatException e) {
                logger.warn("An error occurred while decompressing data", (Throwable)e);
                return;
            }
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException count) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        try {
            String message = new String(decompressedData, "UTF-8");
            logger.trace("onTextMessage: text='{}'", (Object)message);
            this.onTextMessage(websocket, message);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("An error occurred while decompressing data", (Throwable)e);
        }
    }

    private Future<?> startHeartbeat(WebSocket websocket, int heartbeatInterval) {
        this.heartbeatAckReceived.set(true);
        return this.api.getThreadPool().getScheduler().scheduleWithFixedDelay(() -> {
            try {
                if (this.heartbeatAckReceived.getAndSet(false)) {
                    this.sendHeartbeat(websocket);
                    logger.debug("Sent heartbeat (interval: {})", (Object)heartbeatInterval);
                } else {
                    websocket.sendClose(WebSocketCloseReason.HEARTBEAT_NOT_PROPERLY_ANSWERED.getNumericCloseCode(), WebSocketCloseReason.HEARTBEAT_NOT_PROPERLY_ANSWERED.getCloseReason());
                }
            }
            catch (Throwable t) {
                logger.error("Failed to send heartbeat or close web socket!", t);
            }
        }, 0L, heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    private void sendHeartbeat(WebSocket websocket) {
        ObjectNode heartbeatPacket = JsonNodeFactory.instance.objectNode();
        heartbeatPacket.put("op", GatewayOpcode.HEARTBEAT.getCode());
        heartbeatPacket.put("d", this.lastSeq);
        WebSocketFrame heartbeatFrame = WebSocketFrame.createTextFrame(heartbeatPacket.toString());
        this.nextHeartbeatFrame.set(heartbeatFrame);
        websocket.sendFrame(heartbeatFrame);
    }

    private void sendResume(WebSocket websocket) {
        ObjectNode resumePacket = JsonNodeFactory.instance.objectNode().put("op", GatewayOpcode.RESUME.getCode());
        resumePacket.putObject("d").put("token", this.api.getPrefixedToken()).put("session_id", this.sessionId).put("seq", this.lastSeq);
        logger.debug("Sending resume packet");
        websocket.sendText(resumePacket.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIdentify(WebSocket websocket) {
        ObjectNode identifyPacket = JsonNodeFactory.instance.objectNode().put("op", GatewayOpcode.IDENTIFY.getCode());
        ObjectNode data = identifyPacket.putObject("d");
        final String token = this.api.getPrefixedToken();
        data.put("token", token).put("compress", true).put("large_threshold", 250).putObject("properties").put("$os", System.getProperty("os.name")).put("$browser", "Javacord").put("$device", "Javacord").put("$referrer", "").put("$referring_domain", "");
        if (this.api.getTotalShards() > 1) {
            data.putArray("shard").add(this.api.getCurrentShard()).add(this.api.getTotalShards());
        }
        List<WebSocketListener> list = this.identifyFrameListeners;
        synchronized (list) {
            websocket.removeListeners(this.identifyFrameListeners);
            this.identifyFrameListeners.clear();
        }
        WebSocketFrame identifyFrame = WebSocketFrame.createTextFrame(identifyPacket.toString());
        this.lastSentFrameWasIdentify.set(identifyFrame, false);
        WebSocketAdapter identifyFrameListener = new WebSocketAdapter(){

            @Override
            public void onFrameSent(WebSocket websocket, WebSocketFrame frame) {
                if (DiscordWebSocketAdapter.this.lastSentFrameWasIdentify.isMarked()) {
                    if (!DiscordWebSocketAdapter.this.nextHeartbeatFrame.compareAndSet(frame, null)) {
                        DiscordWebSocketAdapter.this.lastSentFrameWasIdentify.set(null, false);
                        websocket.removeListener(this);
                        DiscordWebSocketAdapter.this.identifyFrameListeners.remove(this);
                    }
                } else if (DiscordWebSocketAdapter.this.lastSentFrameWasIdentify.compareAndSet(frame, null, false, true)) {
                    lastIdentificationPerAccount.put(token, System.currentTimeMillis());
                    ((Semaphore)connectionDelaySemaphorePerAccount.get(token)).release();
                }
            }
        };
        this.identifyFrameListeners.add(identifyFrameListener);
        websocket.addListener(identifyFrameListener);
        logger.debug("Sending identify packet");
        websocket.sendFrame(identifyFrame);
    }

    public void sendVoiceStateUpdate(Server server, ServerVoiceChannel channel, Boolean selfMuted, Boolean selfDeafened) {
        ObjectNode updateVoiceStatePacket = JsonNodeFactory.instance.objectNode().put("op", GatewayOpcode.VOICE_STATE_UPDATE.getCode());
        if (server == null) {
            if (channel == null) {
                throw new IllegalArgumentException("Either server or channel must be given");
            }
            server = channel.getServer();
        }
        User yourself = this.api.getYourself();
        updateVoiceStatePacket.putObject("d").put("guild_id", server.getIdAsString()).put("channel_id", channel == null ? null : channel.getIdAsString()).put("self_mute", selfMuted == null ? server.isSelfMuted(yourself) : selfMuted.booleanValue()).put("self_deaf", selfDeafened == null ? server.isSelfDeafened(yourself) : selfDeafened.booleanValue());
        logger.debug("Sending VOICE_STATE_UPDATE packet for channel {} on server {}", (Object)channel, (Object)server);
        this.websocket.get().sendText(updateVoiceStatePacket.toString());
    }

    private void registerHandlers() {
        this.addHandler(new ReadyHandler(this.api));
        this.addHandler(new ResumedHandler(this.api));
        this.addHandler(new GuildBanAddHandler(this.api));
        this.addHandler(new GuildBanRemoveHandler(this.api));
        this.addHandler(new GuildCreateHandler(this.api));
        this.addHandler(new GuildDeleteHandler(this.api));
        this.addHandler(new GuildMembersChunkHandler(this.api));
        this.addHandler(new GuildMemberAddHandler(this.api));
        this.addHandler(new GuildMemberRemoveHandler(this.api));
        this.addHandler(new GuildMemberUpdateHandler(this.api));
        this.addHandler(new GuildUpdateHandler(this.api));
        this.addHandler(new VoiceStateUpdateHandler(this.api));
        this.addHandler(new GuildRoleCreateHandler(this.api));
        this.addHandler(new GuildRoleDeleteHandler(this.api));
        this.addHandler(new GuildRoleUpdateHandler(this.api));
        this.addHandler(new GuildEmojisUpdateHandler(this.api));
        this.addHandler(new ChannelCreateHandler(this.api));
        this.addHandler(new ChannelDeleteHandler(this.api));
        this.addHandler(new ChannelPinsUpdateHandler(this.api));
        this.addHandler(new ChannelUpdateHandler(this.api));
        this.addHandler(new WebhooksUpdateHandler(this.api));
        this.addHandler(new PresencesReplaceHandler(this.api));
        this.addHandler(new PresenceUpdateHandler(this.api));
        this.addHandler(new TypingStartHandler(this.api));
        this.addHandler(new UserUpdateHandler(this.api));
        this.addHandler(new MessageCreateHandler(this.api));
        this.addHandler(new MessageDeleteBulkHandler(this.api));
        this.addHandler(new MessageDeleteHandler(this.api));
        this.addHandler(new MessageUpdateHandler(this.api));
        this.addHandler(new MessageReactionAddHandler(this.api));
        this.addHandler(new MessageReactionRemoveAllHandler(this.api));
        this.addHandler(new MessageReactionRemoveHandler(this.api));
    }

    private void addHandler(PacketHandler handler) {
        this.handlers.put(handler.getType(), handler);
    }

    public WebSocket getWebSocket() {
        return this.websocket.get();
    }

    public CompletableFuture<Boolean> isReady() {
        return this.ready;
    }

    public void updateStatus() {
        Optional<Activity> activity = this.api.getActivity();
        ObjectNode updateStatus = JsonNodeFactory.instance.objectNode().put("op", GatewayOpcode.STATUS_UPDATE.getCode());
        ObjectNode data = updateStatus.putObject("d").put("status", this.api.getStatus().getStatusString()).put("afk", false).putNull("since");
        ObjectNode activityJson = data.putObject("game");
        activityJson.put("name", activity.isPresent() ? activity.get().getName() : null);
        activityJson.put("type", activity.map(g -> g.getType().getId()).orElse(0));
        activity.ifPresent(g -> g.getStreamingUrl().ifPresent(url -> activityJson.put("url", (String)url)));
        logger.debug("Updating status (content: {})", (Object)updateStatus);
        this.websocket.get().sendText(updateStatus.toString());
    }

    public void queueRequestGuildMembers(Server server) {
        logger.debug("Queued {} for request guild members packet", (Object)server);
        this.requestGuildMembersQueue.add(server.getId());
    }

    @Override
    public void onError(WebSocket websocket, WebSocketException cause) {
        switch (cause.getMessage()) {
            case "Flushing frames to the server failed: Connection closed by remote host": 
            case "Flushing frames to the server failed: Socket is closed": 
            case "Flushing frames to the server failed: Connection has been shutdown: javax.net.ssl.SSLException: java.net.SocketException: Connection reset": 
            case "An I/O error occurred while a frame was being read from the web socket: Connection reset": {
                break;
            }
            default: {
                logger.warn("Websocket error!", (Throwable)cause);
            }
        }
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        logger.error("Websocket callback error!", cause);
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) {
        logger.warn("Websocket onUnexpected error!", (Throwable)cause);
    }

    @Override
    public void onConnectError(WebSocket websocket, WebSocketException exception) {
        logger.warn("Websocket onConnect error!", (Throwable)exception);
    }

    static {
        gatewayLock = new ReentrantReadWriteLock();
        gatewayReadLock = gatewayLock.readLock();
        gatewayWriteLock = gatewayLock.writeLock();
        lastIdentificationPerAccount = Collections.synchronizedMap(new HashMap());
        connectionDelaySemaphorePerAccount = new ConcurrentHashMap<String, Semaphore>();
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory("Javacord - Connection Delay Semaphores Starvation Protector", true)).scheduleWithFixedDelay(() -> {
            try {
                connectionDelaySemaphorePerAccount.forEach((token, semaphore) -> {
                    if (semaphore.availablePermits() == 0 && System.currentTimeMillis() - lastIdentificationPerAccount.getOrDefault(token, 0L) >= 15000L) {
                        semaphore.release();
                    }
                });
            }
            catch (Throwable t) {
                logger.error("Failed to do the backup semaphore releasing!", t);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }
}

