/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.user;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordClient;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.activity.Activity;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.IconImpl;
import org.javacord.core.entity.channel.PrivateChannelImpl;
import org.javacord.core.listener.user.InternalUserAttachableListenerManager;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class UserImpl
implements User,
Cleanupable,
InternalUserAttachableListenerManager {
    private static final Logger logger = LoggerUtil.getLogger(UserImpl.class);
    private final DiscordApiImpl api;
    private final long id;
    private volatile String name;
    private volatile PrivateChannel channel = null;
    private volatile String avatarHash = null;
    private volatile String discriminator;
    private final boolean bot;
    private volatile Activity activity = null;
    private volatile UserStatus status = UserStatus.OFFLINE;
    private final Map<DiscordClient, UserStatus> clientStatus = new ConcurrentHashMap<DiscordClient, UserStatus>();

    public UserImpl(DiscordApiImpl api, JsonNode data) {
        this.api = api;
        this.id = Long.parseLong(data.get("id").asText());
        this.name = data.get("username").asText();
        this.discriminator = data.get("discriminator").asText();
        if (data.has("avatar") && !data.get("avatar").isNull()) {
            this.avatarHash = data.get("avatar").asText();
        }
        this.bot = data.has("bot") && data.get("bot").asBoolean();
        api.addUserToCache(this);
    }

    public void setChannel(PrivateChannel channel) {
        if (this.channel != channel) {
            if (this.channel != null) {
                ((Cleanupable)((Object)this.channel)).cleanup();
            }
            this.channel = channel;
        }
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public void setClientStatus(DiscordClient client, UserStatus status) {
        this.clientStatus.put(client, status);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    public String getAvatarHash() {
        return this.avatarHash;
    }

    public void setAvatarHash(String avatarHash) {
        this.avatarHash = avatarHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateChannel getOrCreateChannel(JsonNode data) {
        UserImpl userImpl = this;
        synchronized (userImpl) {
            if (this.channel != null) {
                return this.channel;
            }
            return new PrivateChannelImpl(this.api, data);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public Optional<Activity> getActivity() {
        return Optional.ofNullable(this.activity);
    }

    @Override
    public UserStatus getStatus() {
        return this.status;
    }

    @Override
    public UserStatus getStatusOnClient(DiscordClient client) {
        return this.clientStatus.getOrDefault((Object)client, UserStatus.OFFLINE);
    }

    public static Icon getAvatar(DiscordApi api, String avatarHash, String discriminator, long userId) {
        StringBuilder url = new StringBuilder("https://cdn.discordapp.com/");
        if (avatarHash == null) {
            url.append("embed/avatars/").append(Integer.parseInt(discriminator) % 5).append(".png");
        } else {
            url.append("avatars/").append(userId).append('/').append(avatarHash).append(avatarHash.startsWith("a_") ? ".gif" : ".png");
        }
        try {
            return new IconImpl(api, new URL(url.toString()));
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the avatar is malformed! Please contact the developer!", (Throwable)e);
            return null;
        }
    }

    @Override
    public Icon getAvatar() {
        return UserImpl.getAvatar(this.api, this.avatarHash, this.discriminator, this.id);
    }

    @Override
    public boolean hasDefaultAvatar() {
        return this.avatarHash == null;
    }

    @Override
    public Optional<PrivateChannel> getPrivateChannel() {
        return Optional.ofNullable(this.channel);
    }

    @Override
    public CompletableFuture<PrivateChannel> openPrivateChannel() {
        if (this.channel != null) {
            return CompletableFuture.completedFuture(this.channel);
        }
        return new RestRequest(this.api, RestMethod.POST, RestEndpoint.USER_CHANNEL).setBody(JsonNodeFactory.instance.objectNode().put("recipient_id", this.getIdAsString())).execute(result -> this.getOrCreateChannel(result.getJsonBody()));
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void cleanup() {
        if (this.channel != null) {
            ((Cleanupable)((Object)this.channel)).cleanup();
        }
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("User (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

