/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.permission;

import org.javacord.api.entity.permission.PermissionState;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.permission.Permissions;

public class PermissionsImpl
implements Permissions {
    public static final Permissions EMPTY_PERMISSIONS = new PermissionsImpl(0, 0);
    private final int allowed;
    private final int denied;

    public PermissionsImpl(int allow, int deny) {
        this.allowed = allow;
        this.denied = deny;
    }

    public PermissionsImpl(int allow) {
        this.allowed = allow;
        int tempDenied = 0;
        for (PermissionType type : PermissionType.values()) {
            if (type.isSet(allow)) continue;
            tempDenied = type.set(tempDenied, true);
        }
        this.denied = tempDenied;
    }

    @Override
    public int getAllowedBitmask() {
        return this.allowed;
    }

    @Override
    public int getDeniedBitmask() {
        return this.denied;
    }

    @Override
    public PermissionState getState(PermissionType type) {
        if (type.isSet(this.allowed)) {
            return PermissionState.ALLOWED;
        }
        if (type.isSet(this.denied)) {
            return PermissionState.DENIED;
        }
        return PermissionState.UNSET;
    }

    @Override
    public boolean isEmpty() {
        return this.allowed == 0 && this.denied == 0;
    }

    public int hashCode() {
        int hash = 42;
        hash = hash * 11 + this.allowed;
        hash = hash * 17 + this.denied;
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PermissionsImpl)) {
            return false;
        }
        PermissionsImpl other = (PermissionsImpl)obj;
        return other.allowed == this.allowed && other.denied == this.denied;
    }

    public String toString() {
        return "Permissions (allowed: " + this.getAllowedBitmask() + ", denied: " + this.getDeniedBitmask() + ")";
    }
}

