/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Permissionable;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.internal.ServerChannelUpdaterDelegate;
import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.user.User;
import org.javacord.core.entity.channel.ServerChannelImpl;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class ServerChannelUpdaterDelegateImpl
implements ServerChannelUpdaterDelegate {
    protected final ServerChannel channel;
    protected String reason = null;
    protected String name = null;
    protected Integer position = null;
    protected Map<Long, Permissions> overwrittenUserPermissions = null;
    protected Map<Long, Permissions> overwrittenRolePermissions = null;

    public ServerChannelUpdaterDelegateImpl(ServerChannel channel) {
        this.channel = channel;
    }

    @Override
    public void setAuditLogReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRawPosition(int rawPosition) {
        this.position = rawPosition;
    }

    @Override
    public <T extends Permissionable & DiscordEntity> void addPermissionOverwrite(T permissionable, Permissions permissions) {
        this.populatePermissionOverwrites();
        if (permissionable instanceof Role) {
            this.overwrittenRolePermissions.put(((DiscordEntity)permissionable).getId(), permissions);
        } else if (permissionable instanceof User) {
            this.overwrittenUserPermissions.put(((DiscordEntity)permissionable).getId(), permissions);
        }
    }

    @Override
    public <T extends Permissionable & DiscordEntity> void removePermissionOverwrite(T permissionable) {
        this.populatePermissionOverwrites();
        if (permissionable instanceof Role) {
            this.overwrittenRolePermissions.remove(((DiscordEntity)permissionable).getId());
        } else if (permissionable instanceof User) {
            this.overwrittenUserPermissions.remove(((DiscordEntity)permissionable).getId());
        }
    }

    @Override
    public CompletableFuture<Void> update() {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (this.prepareUpdateBody(body)) {
            return new RestRequest(this.channel.getApi(), RestMethod.PATCH, RestEndpoint.CHANNEL).setUrlParameters(this.channel.getIdAsString()).setBody(body).setAuditLogReason(this.reason).execute(result -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected boolean prepareUpdateBody(ObjectNode body) {
        boolean patchChannel = false;
        if (this.name != null) {
            body.put("name", this.name);
            patchChannel = true;
        }
        if (this.position != null) {
            body.put("position", (int)this.position);
            patchChannel = true;
        }
        ArrayNode permissionOverwrites = null;
        if (this.overwrittenUserPermissions != null || this.overwrittenRolePermissions != null) {
            permissionOverwrites = body.putArray("permission_overwrites");
            patchChannel = true;
        }
        if (this.overwrittenUserPermissions != null) {
            for (Map.Entry<Long, Permissions> entry : this.overwrittenUserPermissions.entrySet()) {
                permissionOverwrites.addObject().put("id", Long.toUnsignedString(entry.getKey())).put("type", "member").put("allow", entry.getValue().getAllowedBitmask()).put("deny", entry.getValue().getDeniedBitmask());
            }
        }
        if (this.overwrittenRolePermissions != null) {
            for (Map.Entry<Long, Permissions> entry : this.overwrittenRolePermissions.entrySet()) {
                permissionOverwrites.addObject().put("id", Long.toUnsignedString(entry.getKey())).put("type", "role").put("allow", entry.getValue().getAllowedBitmask()).put("deny", entry.getValue().getDeniedBitmask());
            }
        }
        return patchChannel;
    }

    private void populatePermissionOverwrites() {
        if (this.overwrittenUserPermissions == null) {
            this.overwrittenUserPermissions = new HashMap<Long, Permissions>();
            this.overwrittenUserPermissions.putAll(((ServerChannelImpl)this.channel).getInternalOverwrittenUserPermissions());
        }
        if (this.overwrittenRolePermissions == null) {
            this.overwrittenRolePermissions = new HashMap<Long, Permissions>();
            this.overwrittenRolePermissions.putAll(((ServerChannelImpl)this.channel).getInternalOverwrittenRolePermissions());
        }
    }
}

