/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Permissionable;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.permission.PermissionState;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.PermissionsBuilder;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.invite.RichInvite;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.permission.PermissionsImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.server.invite.InviteImpl;
import org.javacord.core.listener.channel.server.InternalServerChannelAttachableListenerManager;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public abstract class ServerChannelImpl
implements ServerChannel,
InternalServerChannelAttachableListenerManager {
    private final DiscordApiImpl api;
    private final long id;
    private volatile String name;
    private final ServerImpl server;
    private volatile int position;
    private final ConcurrentHashMap<Long, Permissions> overwrittenUserPermissions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Permissions> overwrittenRolePermissions = new ConcurrentHashMap();

    public ServerChannelImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        this.api = api;
        this.server = server;
        this.id = Long.parseLong(data.get("id").asText());
        this.name = data.get("name").asText();
        this.position = data.get("position").asInt();
        if (data.has("permission_overwrites")) {
            block8: for (JsonNode permissionOverwrite : data.get("permission_overwrites")) {
                long id = Long.parseLong(permissionOverwrite.has("id") ? permissionOverwrite.get("id").asText() : "-1");
                int allow = permissionOverwrite.has("allow") ? permissionOverwrite.get("allow").asInt() : 0;
                int deny = permissionOverwrite.has("deny") ? permissionOverwrite.get("deny").asInt() : 0;
                PermissionsImpl permissions = new PermissionsImpl(allow, deny);
                switch (permissionOverwrite.get("type").asText()) {
                    case "role": {
                        this.overwrittenRolePermissions.put(id, permissions);
                        continue block8;
                    }
                    case "member": {
                        this.overwrittenUserPermissions.put(id, permissions);
                        continue block8;
                    }
                }
                LoggerUtil.getLogger(ServerChannelImpl.class).warn("Unknown type for permission_overwrites. Your Javacord version might be outdated.");
            }
        }
        api.addChannelToCache(this);
        server.addChannelToCache(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ConcurrentHashMap<Long, Permissions> getInternalOverwrittenRolePermissions() {
        return this.overwrittenRolePermissions;
    }

    public ConcurrentHashMap<Long, Permissions> getInternalOverwrittenUserPermissions() {
        return this.overwrittenUserPermissions;
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public int getRawPosition() {
        return this.position;
    }

    @Override
    public CompletableFuture<Collection<RichInvite>> getInvites() {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.CHANNEL_INVITE).setUrlParameters(this.getIdAsString()).execute(result -> {
            HashSet<InviteImpl> invites = new HashSet<InviteImpl>();
            for (JsonNode inviteJson : result.getJsonBody()) {
                invites.add(new InviteImpl(this.getApi(), inviteJson));
            }
            return Collections.unmodifiableCollection(invites);
        });
    }

    @Override
    public <T extends Permissionable & DiscordEntity> Permissions getOverwrittenPermissions(T permissionable) {
        Map permissionsMap = Collections.emptyMap();
        if (permissionable instanceof User) {
            permissionsMap = this.overwrittenUserPermissions;
        } else if (permissionable instanceof Role) {
            permissionsMap = this.overwrittenRolePermissions;
        }
        return permissionsMap.getOrDefault(((DiscordEntity)permissionable).getId(), PermissionsImpl.EMPTY_PERMISSIONS);
    }

    @Override
    public Map<User, Permissions> getOverwrittenUserPermissions() {
        Server server = this.getServer();
        return Collections.unmodifiableMap(this.overwrittenUserPermissions.entrySet().stream().collect(Collectors.toMap(entry -> server.getMemberById((Long)entry.getKey()).orElseThrow(AssertionError::new), Map.Entry::getValue)));
    }

    @Override
    public Map<Role, Permissions> getOverwrittenRolePermissions() {
        Server server = this.getServer();
        return Collections.unmodifiableMap(this.overwrittenRolePermissions.entrySet().stream().collect(Collectors.toMap(entry -> server.getRoleById((Long)entry.getKey()).orElseThrow(AssertionError::new), Map.Entry::getValue)));
    }

    @Override
    public Permissions getEffectiveOverwrittenPermissions(User user) {
        PermissionsBuilder builder = new PermissionsBuilder(PermissionsImpl.EMPTY_PERMISSIONS);
        Server server = this.getServer();
        Role everyoneRole = server.getEveryoneRole();
        Permissions everyoneRolePermissionOverwrites = this.getOverwrittenPermissions(everyoneRole);
        for (PermissionType type : PermissionType.values()) {
            if (everyoneRolePermissionOverwrites.getState(type) == PermissionState.DENIED) {
                builder.setState(type, PermissionState.DENIED);
            }
            if (everyoneRolePermissionOverwrites.getState(type) != PermissionState.ALLOWED) continue;
            builder.setState(type, PermissionState.ALLOWED);
        }
        ArrayList<Role> rolesOfUser = new ArrayList<Role>(server.getRoles(user));
        rolesOfUser.remove(everyoneRole);
        List permissionOverwrites = rolesOfUser.stream().map(this::getOverwrittenPermissions).collect(Collectors.toList());
        for (Permissions permissions : permissionOverwrites) {
            for (PermissionType type : PermissionType.values()) {
                if (permissions.getState(type) != PermissionState.DENIED) continue;
                builder.setState(type, PermissionState.DENIED);
            }
        }
        for (Permissions permissions : permissionOverwrites) {
            for (PermissionType type : PermissionType.values()) {
                if (permissions.getState(type) != PermissionState.ALLOWED) continue;
                builder.setState(type, PermissionState.ALLOWED);
            }
        }
        for (PermissionType type : PermissionType.values()) {
            Permissions permissions = this.getOverwrittenPermissions(user);
            if (permissions.getState(type) == PermissionState.DENIED) {
                builder.setState(type, PermissionState.DENIED);
            }
            if (permissions.getState(type) != PermissionState.ALLOWED) continue;
            builder.setState(type, PermissionState.ALLOWED);
        }
        return builder.build();
    }

    @Override
    public CompletableFuture<Void> delete(String reason) {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.CHANNEL).setUrlParameters(this.getIdAsString()).setAuditLogReason(reason).execute(result -> null);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("ServerChannel (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

