/*
 * Decompiled with CFR 0.152.
 */
package web;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import web.Jsonizable;

public class JSON {
    private static final Map<Character, String> REPLACE_LIST = new LinkedHashMap<Character, String>();

    public static Object decode(String json) throws JSONException {
        return JSON.walkItem(new StringWalker(json));
    }

    private static Object walkItem(StringWalker json) throws JSONException {
        json.trimStart();
        if (json.getChar() == '\"') {
            return JSON.walkString(json);
        }
        if (json.getChar() == '[') {
            return JSON.walkList(json);
        }
        if (json.getChar() == '{') {
            return JSON.walkObject(json);
        }
        return JSON.walkBooleanOrNumber(json);
    }

    private static Map<String, Object> walkObject(StringWalker json) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        json.next();
        while (!json.isAtEnd()) {
            json.trimStart();
            if (json.getChar() == '}') {
                json.next();
                break;
            }
            if (json.getChar() == ',') {
                json.next();
                continue;
            }
            JSONEntry e = JSON.walkEntry(json);
            map.put(e.key, e.value);
        }
        return map;
    }

    private static JSONEntry walkEntry(StringWalker json) throws JSONException {
        JSONEntry entry = new JSONEntry();
        entry.key = JSON.walkString(json);
        json.trimStart();
        if (json.getChar() != ':') {
            throw new JSONException();
        }
        json.next();
        entry.value = JSON.walkItem(json);
        return entry;
    }

    private static List<Object> walkList(StringWalker json) throws JSONException {
        LinkedList<Object> list = new LinkedList<Object>();
        json.next();
        while (!json.isAtEnd()) {
            json.trimStart();
            if (json.getChar() == ']') {
                json.next();
                break;
            }
            if (json.getChar() == ',') {
                json.next();
                continue;
            }
            list.add(JSON.walkItem(json));
        }
        return list;
    }

    private static Object walkBooleanOrNumber(StringWalker json) throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (!json.isAtEnd() && !Character.isWhitespace(json.getChar()) && json.getChar() != ',' && json.getChar() != ']' && json.getChar() != '}') {
            sb.append(json.getChar());
            json.next();
        }
        String obj = sb.toString();
        if (obj.equals("true")) {
            return true;
        }
        if (obj.equals("false")) {
            return false;
        }
        if (obj.equals("null")) {
            return null;
        }
        try {
            return Double.parseDouble(obj);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException();
        }
    }

    private static String walkString(StringWalker json) throws JSONException {
        if (json.getChar() != '\"') {
            throw new JSONException();
        }
        json.next();
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (json.isAtEnd()) {
                throw new JSONException();
            }
            if (json.getChar() == '\"') break;
            if (json.getChar() == '\\') {
                json.next();
                if (json.isAtEnd()) {
                    throw new JSONException();
                }
                switch (json.getChar()) {
                    case 'b': {
                        sb.append('\b');
                        json.next();
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        json.next();
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        json.next();
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        json.next();
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        json.next();
                        break;
                    }
                    case 'u': {
                        sb.append(JSON.walkUnicode(json));
                        json.next();
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        json.next();
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        json.next();
                    }
                }
                continue;
            }
            sb.append(json.getChar());
            json.next();
        }
        json.next();
        return sb.toString();
    }

    public static char walkUnicode(StringWalker json) throws JSONException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (json.isAtEnd()) {
                throw new JSONException();
            }
            json.next();
            sb.append(json.getChar());
        }
        return (char)Integer.parseInt(sb.toString(), 16);
    }

    public static String encode(Object obj) {
        return JSON.encode(obj, null);
    }

    public static String encode(Object obj, Set<String> escape) {
        if (escape == null) {
            escape = new HashSet<String>();
        }
        StringBuilder sb = new StringBuilder();
        JSON.encodeFindType(sb, obj, escape);
        return sb.toString();
    }

    private static void encodeCollection(StringBuilder sb, Collection value) {
        sb.append("[");
        boolean first = true;
        for (Object v : value) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            JSON.encodeFindType(sb, v);
        }
        sb.append("]");
    }

    private static void encodeMap(StringBuilder sb, Map value) {
        sb.append("{");
        boolean first = true;
        for (Map.Entry entrySet : value.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"").append(entrySet.getKey()).append("\":");
            JSON.encodeFindType(sb, entrySet.getValue());
        }
        sb.append("}");
    }

    private static void encodeObject(StringBuilder sb, Object value, Set<String> escape) {
        sb.append("{");
        Class<?> clazz = value.getClass();
        boolean first = true;
        for (Field field : clazz.getDeclaredFields()) {
            if (escape.contains(field.getName())) continue;
            try {
                Object v = field.get(value);
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append("\"").append(field.getName()).append("\":");
                JSON.encodeFindType(sb, v);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        sb.append("}");
    }

    private static String formatString(String string) {
        StringBuilder sb = new StringBuilder(string);
        int length = sb.length();
        for (int i = 0; i < length; ++i) {
            if (!REPLACE_LIST.containsKey(Character.valueOf(sb.charAt(i)))) continue;
            String s = REPLACE_LIST.get(Character.valueOf(sb.charAt(i)));
            sb.replace(i, i + 1, s);
            length += -1 + s.length();
            i += -1 + s.length();
        }
        return sb.toString();
    }

    private static void encodeFindType(StringBuilder sb, Object value) {
        JSON.encodeFindType(sb, value, new HashSet<String>());
    }

    private static void encodeFindType(StringBuilder sb, Object value, Set<String> escape) {
        if (value == null) {
            sb.append("null");
            return;
        }
        if (value instanceof String || value instanceof Character || value instanceof Byte) {
            sb.append("\"").append(JSON.formatString((String)value)).append("\"");
            return;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float) {
            sb.append(value);
            return;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                sb.append("true");
            } else {
                sb.append("false");
            }
            return;
        }
        if (value instanceof Collection) {
            JSON.encodeCollection(sb, (Collection)value);
            return;
        }
        if (value instanceof Map) {
            JSON.encodeMap(sb, (Map)value);
            return;
        }
        if (value instanceof Object[]) {
            JSON.encodeArray(sb, (Object[])value);
            return;
        }
        if (value instanceof Jsonizable) {
            JSON.encodeJsonizable(sb, (Jsonizable)value);
            return;
        }
        JSON.encodeObject(sb, value, escape);
    }

    private static void encodeJsonizable(StringBuilder sb, Jsonizable object) {
        JSON.encodeFindType(sb, object.toJsonObject());
    }

    private static void encodeArray(StringBuilder sb, Object[] value) {
        sb.append("[");
        boolean first = true;
        for (Object v : value) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            JSON.encodeFindType(sb, v);
        }
        sb.append("]");
    }

    static {
        REPLACE_LIST.put(Character.valueOf('\\'), "\\\\");
        REPLACE_LIST.put(Character.valueOf('\"'), "\\\"");
        REPLACE_LIST.put(Character.valueOf('/'), "\\/");
        REPLACE_LIST.put(Character.valueOf('\b'), "\\b");
        REPLACE_LIST.put(Character.valueOf('\f'), "\\f");
        REPLACE_LIST.put(Character.valueOf('\r'), "\\r");
        REPLACE_LIST.put(Character.valueOf('\n'), "\\n");
        REPLACE_LIST.put(Character.valueOf('\t'), "\\t");
    }

    public static class JSONEntry {
        public String key;
        public Object value;
    }

    public static class StringWalker {
        char[] string;
        int position = 0;

        public StringWalker(String string) {
            this.string = string.toCharArray();
        }

        public boolean isAtEnd() {
            return this.position > this.string.length - 1;
        }

        public char getChar() {
            return this.string[this.position];
        }

        public boolean hasNext() {
            return this.position + 1 <= this.string.length - 1;
        }

        public void next() {
            ++this.position;
        }

        public void trimStart() {
            while (this.hasNext() && Character.isWhitespace(this.string[this.position])) {
                this.next();
            }
        }
    }

    public static class JSONException
    extends Exception {
    }
}

