/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.xml.bind.DatatypeConverter;
import utils.FS;

public class Utils {
    private static MessageDigest sha1md;
    private static MessageDigest sha512md;

    public static String longToHexString(long l) {
        return String.format("%08X", l);
    }

    public static long crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public static String base64encode(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    public static byte[] base64decode(String base64) {
        return DatatypeConverter.parseBase64Binary((String)base64);
    }

    public static byte[] sha1(byte[] data) {
        sha1md.reset();
        sha1md.update(data);
        return sha1md.digest();
    }

    public static byte[] sha512(byte[] data) {
        sha512md.reset();
        sha512md.update(data);
        return sha512md.digest();
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String getExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        return Utils.getExtension(file.getName());
    }

    public static void GzipFile(File input, File output) throws FileNotFoundException, IOException {
        FS.GzipFile(input, output);
    }

    public static void GzipDirectory(File directory, String extension) throws IOException {
        FS.GzipDirectory(directory, extension);
    }

    public static String capitalizeFirstLetter(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static boolean mkdirs(String path) throws SecurityException {
        return FS.mkdirs(path);
    }

    public static String rot13(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        try {
            sha1md = MessageDigest.getInstance("SHA-1");
            sha512md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

