/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class FS {
    public static void GzipFile(File input, File output) throws FileNotFoundException, IOException {
        int len;
        byte[] buffer = new byte[1024];
        FileInputStream inputstream = new FileInputStream(input);
        FileOutputStream outputStream = new FileOutputStream(output);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        while ((len = inputstream.read(buffer)) > 0) {
            gzipOutputStream.write(buffer, 0, len);
        }
        inputstream.close();
        gzipOutputStream.finish();
        gzipOutputStream.close();
        outputStream.close();
    }

    public static void GzipDirectory(File directory, String extension) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        })) {
            FS.GzipFile(file, new File(file.getAbsolutePath() + "." + extension));
        }
    }

    public static boolean mkdirs(String path) throws SecurityException {
        File file = new File(path);
        if (!file.isDirectory()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean isDir(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    public static boolean isFile(String path) {
        File f = new File(path);
        return f.isFile();
    }

    public static boolean isAbsolute(String path) {
        File f = new File(path);
        return f.isAbsolute();
    }
}

