/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class Template {
    private final String LAYOUT;
    private final Map<String, StringBuilder> TO_APPEND = new HashMap<String, StringBuilder>();

    public Template(String content) {
        this.LAYOUT = content;
    }

    public static Template build(String content) {
        return new Template(content);
    }

    public Template append(String key, String value) {
        if (!this.TO_APPEND.containsKey(key)) {
            this.TO_APPEND.put(key, new StringBuilder());
        }
        this.TO_APPEND.get(key).append(value);
        return this;
    }

    public byte[] getBytes() {
        try {
            return this.getContent().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return this.getContent().getBytes();
        }
    }

    public String getContent() {
        StringBuilder content = new StringBuilder(this.LAYOUT);
        for (Map.Entry<String, StringBuilder> entry : this.TO_APPEND.entrySet()) {
            String key = "{{" + entry.getKey() + "}}";
            String value = entry.getValue().toString();
            int index = content.indexOf(key);
            while (index != -1) {
                content.replace(index, index + key.length(), value);
                index += value.length();
                index = content.indexOf(key, index);
            }
        }
        return content.toString();
    }

    public String toString() {
        return this.getContent();
    }
}

