/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.Utils;

public class Resources {
    private static final HashMap<String, String> MIME_TYPES = new HashMap();
    private static final HashMap<File, Resource> RESOURCES = new HashMap();

    public static void cacheFile(File file) {
        try {
            RESOURCES.put(file, new Resource(file, Resources.getMime(file), Files.readAllBytes(file.toPath())));
        }
        catch (IOException ex) {
            Logger.getLogger(Resources.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cacheDirectory(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                Resources.cacheDirectory(file);
                continue;
            }
            Resources.cacheFile(file);
        }
    }

    public static byte[] getAsBinary(String path) {
        return Resources.getAsBinary(new File(path));
    }

    public static byte[] getAsBinary(File file) {
        if (!file.isFile()) {
            return null;
        }
        if (RESOURCES.containsKey(file)) {
            return Resources.RESOURCES.get((Object)file).content;
        }
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException ex) {
            Logger.getLogger(Resources.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String getAsString(String path) {
        return Resources.getAsString(new File(path));
    }

    public static String getAsString(File file) {
        byte[] res = Resources.getAsBinary(file);
        if (res == null) {
            return null;
        }
        return new String(res);
    }

    public static String getMime(File file) {
        if (RESOURCES.containsKey(file = file.getAbsoluteFile())) {
            return Resources.RESOURCES.get((Object)file).mimeType;
        }
        try {
            String mime = MIME_TYPES.get(Utils.getExtension(file));
            if (mime != null) {
                return mime;
            }
            mime = Files.probeContentType(file.toPath());
            if (mime != null) {
                return mime;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Resources.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "plain/text";
    }

    static {
        MIME_TYPES.put("js", "application/javascript");
        MIME_TYPES.put("ico", "image/vnd.microsoft.icon");
        MIME_TYPES.put("ttf", "application/x-font-ttf");
        MIME_TYPES.put("woff", "application/x-font-woff");
        MIME_TYPES.put("woff2", "application/font-woff2");
    }

    private static class Resource {
        File file;
        String mimeType;
        byte[] content;

        public Resource(File file, String mimeType, byte[] content) {
            this.file = file;
            this.mimeType = mimeType;
            this.content = content;
        }
    }
}

