/*
 * Decompiled with CFR 0.152.
 */
package args;

import java.util.HashMap;

public class Args {
    private final HashMap<String, String> argv;

    public static HashMap<String, String> getArgs(String[] args) {
        HashMap<String, String> argv = new HashMap<String, String>();
        String last = null;
        int count = 0;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (last != null) {
                    argv.put(last, null);
                }
                last = arg.substring(1);
                continue;
            }
            if (last != null) {
                argv.put(last, arg);
                last = null;
                continue;
            }
            argv.put(count + "", arg);
            ++count;
        }
        if (last != null) {
            argv.put(last, null);
        }
        return argv;
    }

    public Args(String[] args) {
        this.argv = Args.getArgs(args);
    }

    public String get(String key) {
        return this.argv.get(key);
    }

    public boolean has(String key) {
        return this.argv.containsKey(key);
    }

    public Integer getInt(String key) {
        String r = this.get(key);
        if (r == null) {
            return null;
        }
        try {
            return Integer.parseInt(r);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getLong(String key) {
        String r = this.get(key);
        if (r == null) {
            return null;
        }
        try {
            return Long.parseLong(r);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double getDouble(String key) {
        String r = this.get(key);
        if (r == null) {
            return null;
        }
        try {
            return Double.parseDouble(r);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

