/*
 * Decompiled with CFR 0.152.
 */
package com.regdrasil.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ExtendedSimpleFormatter
extends Formatter {
    private String format = "[%1$tF %1$tT]\t%4$s\t%5$s%6$s";

    public ExtendedSimpleFormatter() {
    }

    public ExtendedSimpleFormatter(String format) {
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String format(LogRecord record) {
        Object source;
        Date dat = new Date(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(this.format, dat, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }
}

