/*
 * Decompiled with CFR 0.152.
 */
package Log;

import Log.ExtendedSimpleFormatter;
import Log.StdHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    public static final int LEVEL_NO_LOG = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_DEBUG = 4;
    public static final int LEVEL_VERBOSE = 5;
    private static int debugMode = 3;
    private static final Logger LOG = Logger.getLogger("global");
    private static final ExtendedSimpleFormatter FORMATTER = new ExtendedSimpleFormatter();

    public static void setHandler(Handler h) {
        Handler[] handlers;
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        h.setFormatter(FORMATTER);
        rootLogger.addHandler(h);
    }

    public static void addHandler(Handler handler) {
        Logger rootLogger = Logger.getLogger("");
        handler.setFormatter(FORMATTER);
        rootLogger.addHandler(handler);
    }

    public static int getDebugMode() {
        return debugMode;
    }

    public static void e(String message) {
        Log.log(1, message);
    }

    public static void e(String message, Throwable ex) {
        Log.log(1, message, ex);
    }

    public static void w(String message) {
        Log.log(2, message);
    }

    public static void w(String message, Throwable ex) {
        Log.log(2, message, ex);
    }

    public static void i(String message) {
        Log.log(3, message);
    }

    public static void d(String message) {
        Log.log(4, message);
    }

    public static void d(String message, Throwable ex) {
        Log.log(1, message, ex);
    }

    public static void v(String message) {
        Log.log(5, message);
    }

    private static void setLevel(Level level) {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(level);
    }

    public static void setDebugMode(int mode) {
        debugMode = mode;
        switch (mode) {
            case 1: {
                Log.setLevel(Level.SEVERE);
                break;
            }
            case 2: {
                Log.setLevel(Level.WARNING);
                break;
            }
            case 3: {
                Log.setLevel(Level.INFO);
                break;
            }
            case 4: {
                Log.setLevel(Level.CONFIG);
                break;
            }
            case 5: {
                Log.setLevel(Level.FINEST);
            }
        }
    }

    private static void log(int debug, String message) {
        Log.log(debug, message, null);
    }

    private static void log(int debug, String message, Throwable ex) {
        switch (debug) {
            case 1: {
                if (ex == null) {
                    LOG.log(Level.SEVERE, message);
                    break;
                }
                LOG.log(Level.SEVERE, message, ex);
                break;
            }
            case 2: {
                if (ex == null) {
                    LOG.log(Level.WARNING, message);
                    break;
                }
                LOG.log(Level.WARNING, message, ex);
                break;
            }
            case 3: {
                if (ex == null) {
                    LOG.log(Level.INFO, message);
                    break;
                }
                LOG.log(Level.INFO, message, ex);
                break;
            }
            case 4: {
                if (ex == null) {
                    LOG.log(Level.CONFIG, message);
                    break;
                }
                LOG.log(Level.CONFIG, message, ex);
                break;
            }
            case 5: {
                if (ex == null) {
                    LOG.log(Level.FINE, message);
                    break;
                }
                LOG.log(Level.FINE, message, ex);
            }
        }
    }

    static {
        Log.setHandler(new StdHandler());
        Log.setDebugMode(3);
    }
}

